/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MaterialContainer {
    private Material material = null;
    private short dmg = 0;
    private int amount = 1;

    public MaterialContainer(ItemStack is) {
        this.material = is.getType();
        this.dmg = is.getDurability();
    }

    public MaterialContainer(String mat) {
        String[] info = new String[2];
        if (mat.contains(":")) {
            info = mat.split(":");
        } else {
            info[0] = mat;
            info[1] = "0";
        }
        this.parseMat(info[0]);
        this.parseDmg(info[1]);
    }

    public void setAmount(int amount) {
        if (this.material != null) {
            this.amount = this.material.getMaxStackSize() >= amount ? amount : this.material.getMaxStackSize();
        }
    }

    public MaterialContainer(String mat, String damage) {
        this.parseMat(mat);
        this.parseDmg(damage);
    }

    public MaterialContainer() {
    }

    private void parseMat(String material) {
        Material m = null;
        try {
            int id = Integer.parseInt(material);
            m = Material.getMaterial((int)id);
        }
        catch (NumberFormatException e) {
            m = Material.matchMaterial((String)material);
        }
        this.material = m;
    }

    private void parseDmg(String damage) {
        short d = 0;
        try {
            d = Short.parseShort(damage);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.dmg = d;
    }

    public boolean isNull() {
        return this.material == null;
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack(this.material, amount, this.dmg);
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.amount);
    }

    public String toString() {
        if (this.material != null) {
            return this.material.getId() + ":" + this.dmg;
        }
        return "";
    }

    public String display() {
        if (this.material != null) {
            return this.material + ":" + this.dmg;
        }
        return "";
    }

    public Material getMaterial() {
        return this.material;
    }
}

