/*
 * Decompiled with CFR 0.152.
 */
package de.fgtech.pomo4ka.AuthMe.DataController;

import de.fgtech.pomo4ka.AuthMe.DataController.DataSource.DataSource;
import de.fgtech.pomo4ka.AuthMe.DataController.RegistrationCache.RegistrationCache;
import de.fgtech.pomo4ka.AuthMe.DataController.RegistrationCache.RegistrationData;
import java.util.Map;

public class DataController {
    private DataSource datas;
    private RegistrationCache regcache;
    private boolean caching = false;

    public DataController(DataSource dataf, boolean caching) {
        this.datas = dataf;
        this.caching = caching;
        if (caching) {
            this.regcache = dataf.loadAllAuths();
        }
    }

    public boolean saveAuth(String playername, String hash, Map<String, String> customInformation) {
        boolean executed = this.datas.saveAuth(playername.toLowerCase(), hash, customInformation);
        if (this.caching && executed) {
            this.regcache.insert(new RegistrationData(playername.toLowerCase(), hash));
        }
        return executed;
    }

    public boolean removeAuth(String playername) {
        boolean executed = this.datas.removeAuth(playername.toLowerCase());
        if (this.caching && executed) {
            this.regcache.remove(playername.toLowerCase());
        }
        return executed;
    }

    public boolean updateAuth(String playername, String hash) {
        boolean executed = this.datas.updateAuth(playername.toLowerCase(), hash);
        if (this.caching && executed) {
            this.regcache.getPlayerData(playername.toLowerCase()).setHash(hash);
        }
        return executed;
    }

    public String getHash(String playername) {
        if (this.caching) {
            return this.regcache.getHash(playername.toLowerCase());
        }
        return this.datas.loadHash(playername.toLowerCase());
    }

    public boolean isPlayerRegistered(String playername) {
        if (this.caching) {
            return this.regcache.isPlayerRegistered(playername.toLowerCase());
        }
        return this.datas.isPlayerRegistered(playername.toLowerCase());
    }

    public int getRegisteredPlayerAmount() {
        if (this.caching) {
            return this.regcache.getRegisteredPlayerAmount();
        }
        return this.datas.getRegisteredPlayerAmount();
    }
}

