/*
 * Decompiled with CFR 0.152.
 */
package de.fgtech.pomo4ka.AuthMe.InventoryCache;

import de.fgtech.pomo4ka.AuthMe.InventoryCache.InventoryArmour;
import de.fgtech.pomo4ka.AuthMe.Parameters.Settings;
import java.io.File;
import java.io.FileWriter;
import java.util.Scanner;
import org.bukkit.inventory.ItemStack;

public class FlatfileCache {
    public FlatfileCache() {
        File folder = new File(Settings.CACHE_FOLDER);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public void createCache(String playername, InventoryArmour invarm) {
        File file = new File(String.valueOf(Settings.CACHE_FOLDER) + "/" + playername + ".cache");
        if (file.exists()) {
            return;
        }
        FileWriter writer = null;
        try {
            file.createNewFile();
            writer = new FileWriter(file);
            ItemStack[] invstack = invarm.getInventory();
            int i = 0;
            while (i < invstack.length) {
                int itemid = 0;
                int amount = 0;
                short durability = 0;
                if (invstack[i] != null) {
                    itemid = invstack[i].getTypeId();
                    amount = invstack[i].getAmount();
                    durability = invstack[i].getDurability();
                }
                writer.write("i:" + itemid + ":" + amount + ":" + durability + "\r\n");
                writer.flush();
                ++i;
            }
            ItemStack[] wearstack = invarm.getArmour();
            int i2 = 0;
            while (i2 < wearstack.length) {
                int itemid = 0;
                int amount = 0;
                short durability = 0;
                if (wearstack[i2] != null) {
                    itemid = wearstack[i2].getTypeId();
                    amount = wearstack[i2].getAmount();
                    durability = wearstack[i2].getDurability();
                }
                writer.write("w:" + itemid + ":" + amount + ":" + durability + "\r\n");
                writer.flush();
                ++i2;
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InventoryArmour readCache(String playername) {
        ItemStack[] stacka;
        ItemStack[] stacki;
        block11: {
            File file = new File(String.valueOf(Settings.CACHE_FOLDER) + "/" + playername + ".cache");
            stacki = new ItemStack[36];
            stacka = new ItemStack[4];
            if (!file.exists()) {
                return new InventoryArmour(stacki, stacka);
            }
            Scanner reader = null;
            try {
                try {
                    reader = new Scanner(file);
                    int i = 0;
                    int a = 0;
                    while (reader.hasNextLine()) {
                        String[] in;
                        String line = reader.nextLine();
                        if (!line.contains(":") || (in = line.split(":")).length != 4 || !in[0].equals("i") && !in[0].equals("w")) continue;
                        if (in[0].equals("i")) {
                            stacki[i] = new ItemStack(Integer.parseInt(in[1]), Integer.parseInt(in[2]), Short.parseShort(in[3]));
                            ++i;
                            continue;
                        }
                        stacka[a] = new ItemStack(Integer.parseInt(in[1]), Integer.parseInt(in[2]), Short.parseShort(in[3]));
                        ++a;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (reader != null) {
                        reader.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            if (reader != null) {
                reader.close();
            }
        }
        return new InventoryArmour(stacki, stacka);
    }

    public void removeCache(String playername) {
        File file = new File(String.valueOf(Settings.CACHE_FOLDER) + "/" + playername + ".cache");
        if (file.exists()) {
            file.delete();
        }
    }

    public boolean doesCacheExist(String playername) {
        File file = new File(String.valueOf(Settings.CACHE_FOLDER) + "/" + playername + ".cache");
        return file.exists();
    }
}

