/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.InventoryWorkaround;
import com.earth2me.essentials.ItemDb;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EssentialsEcoPlayerListener
extends PlayerListener {
    Essentials ess;

    EssentialsEcoPlayerListener(Essentials ess) {
        this.ess = ess;
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        String username = user.getName().substring(0, user.getName().length() > 14 ? 14 : user.getName().length());
        if (event.getClickedBlock().getType() != Material.WALL_SIGN && event.getClickedBlock().getType() != Material.SIGN_POST) {
            return;
        }
        CraftSign sign = new CraftSign(event.getClickedBlock());
        if (sign.getLine(0).equals("\u00a71[Buy]") && user.isAuthorized("essentials.signs.buy.use")) {
            try {
                int amount = Integer.parseInt(sign.getLine(1));
                ItemStack item = ItemDb.get(sign.getLine(2), amount);
                double cost = Double.parseDouble(sign.getLine(3).substring(1));
                if (user.getMoney() < cost) {
                    throw new Exception(Util.i18n("notEnoughMoney"));
                }
                user.takeMoney(cost);
                HashMap leftOver = user.getInventory().addItem(new ItemStack[]{item});
                for (ItemStack itemStack : leftOver.values()) {
                    user.getWorld().dropItem(user.getLocation(), itemStack);
                }
                user.updateInventory();
            }
            catch (Throwable ex) {
                user.sendMessage(Util.format("errorWithMessage", ex.getMessage()));
            }
            return;
        }
        if (sign.getLine(0).equals("\u00a71[Sell]") && user.isAuthorized("essentials.signs.sell.use")) {
            try {
                int amount = Integer.parseInt(sign.getLine(1));
                ItemStack item = ItemDb.get(sign.getLine(2), amount);
                double cost = Double.parseDouble(sign.getLine(3).substring(1));
                if (!InventoryWorkaround.containsItem((Inventory)user.getInventory(), true, item)) {
                    throw new Exception(Util.format("missingItems", amount, sign.getLine(2)));
                }
                user.giveMoney(cost);
                InventoryWorkaround.removeItem((Inventory)user.getInventory(), true, item);
                user.updateInventory();
            }
            catch (Throwable ex) {
                user.sendMessage(Util.format("errorWithMessage", ex.getMessage()));
            }
            return;
        }
        if (sign.getLine(0).equals("\u00a71[Trade]") && user.isAuthorized("essentials.signs.trade.use")) {
            try {
                ItemStack qi2;
                String[] l1 = sign.getLines()[1].split("[ :-]+");
                String[] l2 = sign.getLines()[2].split("[ :-]+");
                boolean m1 = l1[0].matches("\\$[0-9]+(\\.[0-9]+)?");
                boolean m2 = l2[0].matches("\\$[0-9]+(\\.[0-9]+)?");
                double q1 = Double.parseDouble(m1 ? l1[0].substring(1) : l1[0]);
                double q2 = Double.parseDouble(m2 ? l2[0].substring(1) : l2[0]);
                double r1 = Double.parseDouble(l1[m1 ? 1 : 2]);
                double r2 = Double.parseDouble(l2[m2 ? 1 : 2]);
                r1 = m1 ? r1 : r1 - r1 % q1;
                r2 = m2 ? r2 : r2 - r2 % q2;
                if (!m1 & q1 < 1.0 || !m2 & q2 < 1.0) {
                    throw new Exception(Util.i18n("moreThanZero"));
                }
                ItemStack i1 = m1 || r1 <= 0.0 ? null : ItemDb.get(l1[1], (int)r1);
                ItemStack qi1 = m1 ? null : ItemDb.get(l1[1], (int)q1);
                ItemStack itemStack = qi2 = m2 ? null : ItemDb.get(l2[1], (int)q2);
                if (username.equals(sign.getLines()[3].substring(2))) {
                    if (m1) {
                        user.giveMoney(r1);
                    } else if (i1 != null) {
                        HashMap leftOver = user.getInventory().addItem(new ItemStack[]{i1});
                        for (ItemStack itemStack2 : leftOver.values()) {
                            user.getWorld().dropItem(user.getLocation(), itemStack2);
                        }
                        user.updateInventory();
                    }
                    r1 = 0.0;
                    sign.setLine(1, (m1 ? Util.formatCurrency(q1) : String.format("%.0f", q1) + " " + l1[1]) + ":" + r1);
                    sign.update();
                } else {
                    if (m1) {
                        if (user.getMoney() < q1) {
                            throw new Exception(Util.i18n("notEnoughMoney"));
                        }
                    } else if (!InventoryWorkaround.containsItem((Inventory)user.getInventory(), true, qi1)) {
                        throw new Exception(Util.format("missingItems", (int)q1, l1[1]));
                    }
                    if (r2 < q2) {
                        throw new Exception(Util.i18n("tradeSignEmpty"));
                    }
                    if (m1) {
                        user.takeMoney(q1);
                    } else {
                        InventoryWorkaround.removeItem((Inventory)user.getInventory(), true, qi1);
                    }
                    if (m2) {
                        user.giveMoney(q2);
                    } else {
                        HashMap leftOver = user.getInventory().addItem(new ItemStack[]{qi2});
                        for (ItemStack itemStack3 : leftOver.values()) {
                            user.getWorld().dropItem(user.getLocation(), itemStack3);
                        }
                    }
                    user.updateInventory();
                    sign.setLine(0, "\u00a71[Trade]");
                    sign.setLine(1, (m1 ? Util.formatCurrency(q1) : String.format("%.0f", q1) + " " + l1[1]) + ":" + String.format(m1 ? "%.2f" : "%.0f", Util.roundDouble(r1 += q1)));
                    sign.setLine(2, (m2 ? Util.formatCurrency(q2) : String.format("%.0f", q2) + " " + l2[1]) + ":" + String.format(m2 ? "%.2f" : "%.0f", Util.roundDouble(r2 -= q2)));
                    sign.update();
                    user.sendMessage(Util.i18n("tradeCompleted"));
                }
            }
            catch (Throwable ex) {
                user.sendMessage(Util.format("errorWithMessage", ex.getMessage()));
            }
            return;
        }
    }
}

