/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPlaceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jail
extends BlockListener
implements IConf {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private EssentialsConf config;
    private Essentials ess;

    public Jail(Essentials ess) {
        this.ess = ess;
        this.config = new EssentialsConf(new File(ess.getDataFolder(), "jail.yml"));
        this.config.load();
    }

    public void setJail(Location loc, String jailName) throws Exception {
        this.config.setProperty(jailName.toLowerCase(), loc);
        this.config.save();
    }

    public Location getJail(String jailName) throws Exception {
        if (this.config.getProperty(jailName.toLowerCase()) == null) {
            throw new Exception(Util.i18n("jailNotExist"));
        }
        Location loc = this.config.getLocation(jailName.toLowerCase(), Essentials.getStatic().getServer());
        return loc;
    }

    public void sendToJail(User user, String jail) throws Exception {
        user.getTeleport().now(this.getJail(jail));
        user.setJail(jail);
    }

    public void delJail(String jail) throws Exception {
        this.config.removeProperty(jail.toLowerCase());
        this.config.save();
    }

    public List<String> getJails() throws Exception {
        return this.config.getKeys(null);
    }

    @Override
    public void reloadConfig() {
        this.config.load();
    }

    public void onBlockBreak(BlockBreakEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.isJailed()) {
            event.setCancelled(true);
        }
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.isJailed()) {
            event.setCancelled(true);
        }
    }

    public void onBlockDamage(BlockDamageEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.isJailed()) {
            event.setCancelled(true);
        }
    }
}

