/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Util {
    private static Pattern timePattern = Pattern.compile("(?:([0-9]+)\\s*y[a-z]*[,\\s]*)?(?:([0-9]+)\\s*mo[a-z]*[,\\s]*)?(?:([0-9]+)\\s*w[a-z]*[,\\s]*)?(?:([0-9]+)\\s*d[a-z]*[,\\s]*)?(?:([0-9]+)\\s*h[a-z]*[,\\s]*)?(?:([0-9]+)\\s*m[a-z]*[,\\s]*)?(?:([0-9]+)\\s*(?:s[a-z]*)?)?", 2);
    private static final Locale defaultLocale;
    public static Locale currentLocale;
    private static ResourceBundle bundle;

    public static String sanitizeFileName(String name) {
        return name.toLowerCase().replaceAll("[^a-z0-9]", "_");
    }

    public static String formatDateDiff(long date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(date);
        GregorianCalendar now = new GregorianCalendar();
        return Util.formatDateDiff(now, c);
    }

    public static String formatDateDiff(Calendar fromDate, Calendar toDate) {
        boolean future = false;
        if (toDate.equals(fromDate)) {
            return Util.i18n("now");
        }
        if (toDate.after(fromDate)) {
            future = true;
        }
        StringBuilder sb = new StringBuilder();
        int[] types = new int[]{1, 2, 5, 11, 12, 13};
        String[] names = new String[]{Util.i18n("year"), Util.i18n("years"), Util.i18n("month"), Util.i18n("months"), Util.i18n("day"), Util.i18n("days"), Util.i18n("hour"), Util.i18n("hours"), Util.i18n("minute"), Util.i18n("minutes"), Util.i18n("second"), Util.i18n("seconds")};
        for (int i = 0; i < types.length; ++i) {
            int diff = Util.dateDiff(types[i], fromDate, toDate, future);
            if (diff <= 0) continue;
            sb.append(" ").append(diff).append(" ").append(names[i * 2 + (diff > 1 ? 1 : 0)]);
        }
        if (sb.length() == 0) {
            return "now";
        }
        return sb.toString();
    }

    private static int dateDiff(int type, Calendar fromDate, Calendar toDate, boolean future) {
        int diff = 0;
        while (future && !fromDate.after(toDate) || !future && !fromDate.before(toDate)) {
            fromDate.add(type, future ? 1 : -1);
            ++diff;
        }
        fromDate.add(type, future ? -1 : 1);
        return --diff;
    }

    public static long parseDateDiff(String time, boolean future) throws Exception {
        Matcher m = timePattern.matcher(time);
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        boolean found = false;
        while (m.find()) {
            if (m.group() == null || m.group().isEmpty()) continue;
            for (int i = 0; i < m.groupCount(); ++i) {
                if (m.group(i) == null || m.group(i).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            if (m.group(1) != null && !m.group(1).isEmpty()) {
                years = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null && !m.group(2).isEmpty()) {
                months = Integer.parseInt(m.group(2));
            }
            if (m.group(3) != null && !m.group(3).isEmpty()) {
                weeks = Integer.parseInt(m.group(3));
            }
            if (m.group(4) != null && !m.group(4).isEmpty()) {
                days = Integer.parseInt(m.group(4));
            }
            if (m.group(5) != null && !m.group(5).isEmpty()) {
                hours = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null && !m.group(6).isEmpty()) {
                minutes = Integer.parseInt(m.group(6));
            }
            if (m.group(7) == null || m.group(7).isEmpty()) break;
            seconds = Integer.parseInt(m.group(7));
            break;
        }
        if (!found) {
            throw new Exception("Illegal date format.");
        }
        GregorianCalendar c = new GregorianCalendar();
        if (years > 0) {
            ((Calendar)c).add(1, years * (future ? 1 : -1));
        }
        if (months > 0) {
            ((Calendar)c).add(2, months * (future ? 1 : -1));
        }
        if (weeks > 0) {
            ((Calendar)c).add(3, weeks * (future ? 1 : -1));
        }
        if (days > 0) {
            ((Calendar)c).add(5, days * (future ? 1 : -1));
        }
        if (hours > 0) {
            ((Calendar)c).add(11, hours * (future ? 1 : -1));
        }
        if (minutes > 0) {
            ((Calendar)c).add(12, minutes * (future ? 1 : -1));
        }
        if (seconds > 0) {
            ((Calendar)c).add(13, seconds * (future ? 1 : -1));
        }
        return c.getTimeInMillis();
    }

    public static Location getSafeDestination(Location loc) throws Exception {
        if (loc == null) {
            throw new Exception(Util.i18n("destinationNotSet"));
        }
        World world = loc.getWorld();
        double x = Math.floor(loc.getX()) + 0.5;
        double y = Math.floor(loc.getY());
        double z = Math.floor(loc.getZ()) + 0.5;
        while (Util.isBlockAboveAir(world, x, y, z)) {
            if (!((y -= 1.0) < 0.0)) continue;
            throw new Exception(Util.i18n("holeInFloor"));
        }
        while (Util.isBlockUnsafe(world, x, y, z)) {
            if (!((y += 1.0) >= 110.0)) continue;
            x += 1.0;
            break;
        }
        while (Util.isBlockUnsafe(world, x, y, z)) {
            if (!((y -= 1.0) <= 1.0)) continue;
            y = 110.0;
            x += 1.0;
        }
        return new Location(world, x, y, z, loc.getYaw(), loc.getPitch());
    }

    private static boolean isBlockAboveAir(World world, double x, double y, double z) {
        return world.getBlockAt((int)Math.floor(x), (int)Math.floor(y - 1.0), (int)Math.floor(z)).getType() == Material.AIR;
    }

    public static boolean isBlockUnsafe(World world, double x, double y, double z) {
        Block below = world.getBlockAt((int)Math.floor(x), (int)Math.floor(y - 1.0), (int)Math.floor(z));
        if (below.getType() == Material.LAVA || below.getType() == Material.STATIONARY_LAVA) {
            return true;
        }
        if (below.getType() == Material.FIRE) {
            return true;
        }
        if (world.getBlockAt((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)).getType() != Material.AIR || world.getBlockAt((int)Math.floor(x), (int)Math.floor(y + 1.0), (int)Math.floor(z)).getType() != Material.AIR) {
            return true;
        }
        return Util.isBlockAboveAir(world, x, y, z);
    }

    public static String formatCurrency(double value) {
        return Util.format("currency", value);
    }

    public static double roundDouble(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public static String i18n(String string) {
        return bundle.getString(string);
    }

    public static String format(String string, Object ... objects) {
        MessageFormat mf = new MessageFormat(Util.i18n(string));
        return mf.format(objects);
    }

    public static void updateLocale(String loc, File dataFolder) {
        if (loc == null || loc.isEmpty()) {
            return;
        }
        String[] parts = loc.split("_");
        if (parts.length == 1) {
            currentLocale = new Locale(parts[0]);
        }
        if (parts.length == 2) {
            currentLocale = new Locale(parts[0], parts[1]);
        }
        bundle = ResourceBundle.getBundle("messages", currentLocale, new ConfigClassLoader(dataFolder, Util.class.getClassLoader()));
    }

    static {
        currentLocale = defaultLocale = Locale.getDefault();
        bundle = ResourceBundle.getBundle("messages", defaultLocale);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigClassLoader
    extends ClassLoader {
        private File dataFolder;
        private ClassLoader cl;

        public ConfigClassLoader(File dataFolder, ClassLoader cl) {
            this.dataFolder = dataFolder;
            this.cl = cl;
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.dataFolder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    return this.cl.getResource(string);
                }
            }
            return this.cl.getResource(string);
        }

        @Override
        public synchronized void clearAssertionStatus() {
            this.cl.clearAssertionStatus();
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.dataFolder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {
                    return this.cl.getResourceAsStream(string);
                }
            }
            return this.cl.getResourceAsStream(string);
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            return this.cl.getResources(string);
        }

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            return this.cl.loadClass(string);
        }

        @Override
        public synchronized void setClassAssertionStatus(String string, boolean bln) {
            this.cl.setClassAssertionStatus(string, bln);
        }

        @Override
        public synchronized void setDefaultAssertionStatus(boolean bln) {
            this.cl.setDefaultAssertionStatus(bln);
        }

        @Override
        public synchronized void setPackageAssertionStatus(String string, boolean bln) {
            this.cl.setPackageAssertionStatus(string, bln);
        }
    }
}

