/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import com.earth2me.essentials.commands.EssentialsCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Commandhelp
extends EssentialsCommand {
    public final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());

    public Commandhelp() {
        super("help");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        int page;
        try {
            page = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        }
        catch (Exception ex) {
            page = 1;
        }
        List<String> lines = this.getHelpLines(user);
        int start = (page - 1) * 9;
        int pages = lines.size() / 9 + (lines.size() % 9 > 0 ? 1 : 0);
        user.sendMessage("Page \u00a7c" + page + "\u00a7f of \u00a7c" + pages + "\u00a7f:");
        for (int i = start; i < lines.size() && i < start + 9; ++i) {
            user.sendMessage(lines.get(i));
        }
    }

    @Override
    protected void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        sender.sendMessage("To view help from the console, type \"?\".");
    }

    private List<String> getHelpLines(User user) throws Exception {
        ArrayList<String> retval = new ArrayList<String>();
        File helpFile = new File(this.ess.getDataFolder(), "help_" + Util.sanitizeFileName(user.getName()) + ".txt");
        if (!helpFile.exists()) {
            helpFile = new File(this.ess.getDataFolder(), "help_" + Util.sanitizeFileName(user.getGroup()) + ".txt");
        }
        if (!helpFile.exists()) {
            helpFile = new File(this.ess.getDataFolder(), "help.txt");
        }
        if (helpFile.exists()) {
            BufferedReader rx = new BufferedReader(new FileReader(helpFile));
            String l = null;
            while (rx.ready() && (l = rx.readLine()) != null) {
                retval.add(l.replace('&', '\u00a7'));
            }
            return retval;
        }
        boolean reported = false;
        for (Plugin p : this.ess.getServer().getPluginManager().getPlugins()) {
            try {
                PluginDescriptionFile desc = p.getDescription();
                HashMap cmds = (HashMap)desc.getCommands();
                for (String k : cmds.keySet()) {
                    if (p.getDescription().getName().toLowerCase().contains("essentials")) {
                        String node = "essentials." + k;
                        if (this.ess.getSettings().isCommandDisabled(k) || !user.isAuthorized(node)) continue;
                        HashMap v = (HashMap)cmds.get(k);
                        retval.add("\u00a7c" + k + "\u00a77: " + (String)v.get("description"));
                        continue;
                    }
                    if (!this.ess.getSettings().showNonEssCommandsInHelp()) continue;
                    HashMap v = (HashMap)cmds.get(k);
                    if (v.containsKey("permission") && v.get("permission") != null && !((String)v.get("permission")).equals("")) {
                        if (!user.isAuthorized((String)v.get("permission"))) continue;
                        retval.add("\u00a7c" + k + "\u00a77: " + (String)v.get("description"));
                        continue;
                    }
                    retval.add("\u00a7c" + k + "\u00a77: " + (String)v.get("description"));
                }
            }
            catch (NullPointerException ex) {
            }
            catch (Exception ex) {
                if (!reported) {
                    ex.printStackTrace();
                }
                reported = true;
            }
        }
        return retval;
    }
}

