/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import com.earth2me.essentials.commands.EssentialsCommand;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandkit
extends EssentialsCommand {
    private static final Map<User, Map<String, Long>> kitPlayers = new HashMap<User, Map<String, Long>>();

    public Commandkit() {
        super("kit");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        block21: {
            if (args.length < 1) {
                try {
                    Map kits = (Map)this.ess.getConfiguration().getProperty("kits");
                    StringBuilder list = new StringBuilder();
                    for (String k : kits.keySet()) {
                        if (!user.isAuthorized("essentials.kit." + k)) continue;
                        list.append(" ").append(k);
                    }
                    if (list.length() > 0) {
                        user.sendMessage("\u00a77Kits:" + list.toString());
                        break block21;
                    }
                    user.sendMessage("\u00a77There are no kits available yet");
                }
                catch (Exception ex) {
                    user.sendMessage("\u00a7cThere are no valid kits.");
                }
            } else {
                try {
                    List items;
                    String kitName;
                    block22: {
                        kitName = args[0].toLowerCase();
                        Object kit = this.ess.getSettings().getKit(kitName);
                        if (!user.isAuthorized("essentials.kit." + kitName)) {
                            user.sendMessage("\u00a7cYou need the \u00a7fessentials.kit." + kitName + "\u00a7c permission to use that kit.");
                            return;
                        }
                        try {
                            Map<Object, Object> kitTimes;
                            Map els = (Map)kit;
                            items = (List)els.get("items");
                            double delay = els.containsKey("delay") ? ((Number)els.get("delay")).doubleValue() : 0.0;
                            GregorianCalendar c = new GregorianCalendar();
                            ((Calendar)c).add(13, (int)delay);
                            ((Calendar)c).add(14, (int)(delay * 1000.0 % 1000.0));
                            long time = c.getTimeInMillis();
                            GregorianCalendar now = new GregorianCalendar();
                            if (!kitPlayers.containsKey(user)) {
                                kitTimes = new HashMap<String, Long>();
                                kitTimes.put(kitName, time);
                                kitPlayers.put(user, kitTimes);
                                break block22;
                            }
                            kitTimes = kitPlayers.get(user);
                            if (!kitTimes.containsKey(kitName)) {
                                kitTimes.put(kitName, time);
                                break block22;
                            }
                            if ((Long)kitTimes.get(kitName) < now.getTimeInMillis()) {
                                kitTimes.put(kitName, time);
                                break block22;
                            }
                            user.sendMessage("\u00a7cYou can't use that kit again for another " + Util.formatDateDiff((Long)kitTimes.get(kitName)) + ".");
                            return;
                        }
                        catch (Exception ex) {
                            items = (List)kit;
                        }
                    }
                    try {
                        user.canAfford("kit-" + kitName);
                    }
                    catch (Exception ex) {
                        user.sendMessage(ex.getMessage());
                        return;
                    }
                    boolean spew = false;
                    for (String d : items) {
                        String[] parts = d.split("[^0-9]+", 3);
                        int id = Integer.parseInt(parts[0]);
                        int amount = parts.length > 1 ? Integer.parseInt(parts[parts.length > 2 ? 2 : 1]) : 1;
                        short data = parts.length > 2 ? Short.parseShort(parts[1]) : (short)0;
                        HashMap overfilled = user.getInventory().addItem(new ItemStack[]{new ItemStack(id, amount, data)});
                        for (ItemStack itemStack : overfilled.values()) {
                            user.getWorld().dropItemNaturally(user.getLocation(), itemStack);
                            spew = true;
                        }
                    }
                    if (spew) {
                        user.sendMessage("\u00a77Your inventory was full, placing kit on the floor");
                    }
                    try {
                        user.charge(this);
                        user.charge("kit-" + kitName);
                    }
                    catch (Exception ex) {
                        user.sendMessage(ex.getMessage());
                    }
                    user.sendMessage("\u00a77Giving kit " + args[0].toLowerCase() + ".");
                }
                catch (Exception ex) {
                    user.sendMessage("\u00a7cThat kit does not exist or is improperly defined.");
                    user.sendMessage("\u00a7cPerhaps an item is missing a quantity in the configuration?");
                }
            }
        }
    }
}

