/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandlist
extends EssentialsCommand {
    public Commandlist() {
        super("list");
    }

    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        this.charge(sender);
        StringBuilder online = new StringBuilder();
        online.append(ChatColor.BLUE).append("There are ").append(ChatColor.RED).append(server.getOnlinePlayers().length);
        online.append(ChatColor.BLUE).append(" out of a maximum ").append(ChatColor.RED).append(server.getMaxPlayers());
        online.append(ChatColor.BLUE).append(" players online.");
        sender.sendMessage(online.toString());
        if (this.ess.getSettings().getSortListByGroups()) {
            HashMap<String, ArrayList<User>> sort = new HashMap<String, ArrayList<User>>();
            for (Player p : server.getOnlinePlayers()) {
                User u = this.ess.getUser(p);
                String group = u.getGroup();
                ArrayList<User> list = (ArrayList<User>)sort.get(group);
                if (list == null) {
                    list = new ArrayList<User>();
                    sort.put(group, list);
                }
                list.add(u);
            }
            String[] groups = sort.keySet().toArray(new String[0]);
            Arrays.sort(groups, String.CASE_INSENSITIVE_ORDER);
            for (String group : groups) {
                StringBuilder groupString = new StringBuilder();
                groupString.append(group).append(": ");
                List users = (List)sort.get(group);
                Collections.sort(users);
                boolean first = true;
                for (User user : users) {
                    if (!first) {
                        groupString.append(", ");
                    } else {
                        first = false;
                    }
                    if (user.isAfk()) {
                        groupString.append("\u00a77[AFK]\u00a7f");
                    }
                    groupString.append(user.getDisplayName());
                }
                sender.sendMessage(groupString.toString());
            }
        } else {
            ArrayList<User> users = new ArrayList<User>();
            for (Player p : server.getOnlinePlayers()) {
                users.add(this.ess.getUser(p));
            }
            Collections.sort(users);
            StringBuilder onlineUsers = new StringBuilder();
            onlineUsers.append("Connected players: ");
            boolean first = true;
            for (User user : users) {
                if (!first) {
                    onlineUsers.append(", ");
                } else {
                    first = false;
                }
                if (user.isAfk()) {
                    onlineUsers.append("\u00a77[AFK]\u00a7f");
                }
                onlineUsers.append(user.getDisplayName());
            }
            sender.sendMessage(onlineUsers.toString());
        }
    }
}

