/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.commands.EssentialsCommand;
import java.io.File;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Commandplugin
extends EssentialsCommand {
    private Server server;

    public Commandplugin() {
        super("plugin");
    }

    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        this.server = server;
        PluginCommands sub = null;
        try {
            sub = PluginCommands.valueOf(args[0].toUpperCase());
        }
        catch (Exception ex) {
            sender.sendMessage("\u00a7cUsage: /plugin [load|reload|enable|disable|list] [PluginName]");
            return;
        }
        switch (sub) {
            case LOAD: {
                sender.sendMessage("This function is broken. Performing /reload now.");
                server.reload();
                return;
            }
            case RELOAD: {
                sender.sendMessage("This function is broken. Performing /reload now.");
                server.reload();
                return;
            }
            case ENABLE: {
                sender.sendMessage("This function is broken. Performing /reload now.");
                server.reload();
                return;
            }
            case DISABLE: {
                sender.sendMessage("This function is broken.");
                return;
            }
            case LIST: {
                this.charge(sender);
                this.listPlugins(sender);
                return;
            }
        }
    }

    private void listPlugins(CommandSender player) {
        StringBuilder plugins = new StringBuilder();
        for (Plugin p : this.server.getPluginManager().getPlugins()) {
            plugins.append(p.isEnabled() ? " \u00a7a" : " \u00a7c");
            plugins.append(p.getDescription().getName());
        }
        plugins.insert(0, "\u00a77Plugins:\u00a7f");
        player.sendMessage(plugins.toString());
    }

    private boolean reloadPlugin(String name, CommandSender player) {
        return this.disablePlugin(name, player) && this.enablePlugin(name, player);
    }

    private boolean loadPlugin(String name, CommandSender sender) {
        try {
            PluginManager pm = this.server.getPluginManager();
            pm.loadPlugin(new File("plugins", name + ".jar"));
            sender.sendMessage("\u00a77Plugin loaded.");
            return this.enablePlugin(name, sender);
        }
        catch (Throwable ex) {
            sender.sendMessage("\u00a7cCould not load plugin. Is the file named properly?");
            return false;
        }
    }

    private boolean enablePlugin(String name, CommandSender sender) {
        try {
            final PluginManager pm = this.server.getPluginManager();
            final Plugin plugin = pm.getPlugin(name);
            if (!plugin.isEnabled()) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PluginManager pluginManager = pm;
                        synchronized (pluginManager) {
                            pm.enablePlugin(plugin);
                        }
                    }
                }).start();
            }
            sender.sendMessage("\u00a77Plugin enabled.");
            return true;
        }
        catch (Throwable ex) {
            this.listPlugins(sender);
            return false;
        }
    }

    private boolean disablePlugin(String name, CommandSender sender) {
        try {
            final PluginManager pm = this.server.getPluginManager();
            final Plugin plugin = pm.getPlugin(name);
            if (plugin.isEnabled()) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PluginManager pluginManager = pm;
                        synchronized (pluginManager) {
                            pm.disablePlugin(plugin);
                        }
                    }
                }).start();
            }
            sender.sendMessage("\u00a77Plugin disabled.");
            return true;
        }
        catch (Throwable ex) {
            this.listPlugins(sender);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PluginCommands {
        LOAD,
        RELOAD,
        LIST,
        ENABLE,
        DISABLE;

    }
}

