/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.InventoryWorkaround;
import com.earth2me.essentials.ItemDb;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Commandsell
extends EssentialsCommand {
    public Commandsell() {
        super("sell");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        ItemStack is = null;
        if (args[0].equalsIgnoreCase("hand")) {
            is = user.getItemInHand();
        }
        if (args[0].equalsIgnoreCase("inventory")) {
            for (ItemStack stack : user.getInventory().getContents()) {
                if (stack == null || stack.getType() == Material.AIR) continue;
                this.sellItem(user, stack, args, true);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("blocks")) {
            for (ItemStack stack : user.getInventory().getContents()) {
                if (stack == null || stack.getTypeId() > 255 || stack.getType() == Material.AIR) continue;
                this.sellItem(user, stack, args, true);
            }
            return;
        }
        if (is == null) {
            is = ItemDb.get(args[0]);
        }
        this.sellItem(user, is, args, false);
    }

    private void sellItem(User user, ItemStack is, String[] args, boolean isBulkSell) throws Exception {
        if (is == null || is.getType() == Material.AIR) {
            throw new Exception("You really tried to sell Air? Put an item in your hand.");
        }
        int id = is.getTypeId();
        int amount = 0;
        if (args.length > 1) {
            amount = Integer.parseInt(args[1].replaceAll("[^0-9]", ""));
            if (args[1].startsWith("-")) {
                amount = -amount;
            }
        }
        double worth = Essentials.getWorth().getPrice(is);
        boolean stack = args.length > 1 && args[1].endsWith("s");
        boolean requireStack = this.ess.getConfiguration().getBoolean("trade-in-stacks-" + id, false);
        if (Double.isNaN(worth)) {
            throw new Exception("That item cannot be sold to the server.");
        }
        if (requireStack && !stack) {
            throw new Exception("Item must be traded in stacks. A quantity of 2s would be two stacks, etc.");
        }
        int max = 0;
        if (!isBulkSell) {
            for (ItemStack s : user.getInventory().getContents()) {
                if (s == null || s.getTypeId() != is.getTypeId() || s.getDurability() != is.getDurability()) continue;
                max += s.getAmount();
            }
        } else {
            max += is.getAmount();
        }
        if (stack) {
            amount *= 64;
        }
        if (amount < 1) {
            amount += max;
        }
        if (requireStack) {
            amount -= amount % 64;
        }
        if (amount > max || amount < 1) {
            user.sendMessage("\u00a7cYou do not have enough of that item to sell.");
            user.sendMessage("\u00a77If you meant to sell all of your items of that type, use /sell itemname");
            user.sendMessage("\u00a77/sell itemname -1 will sell all but one item, etc.");
            return;
        }
        this.charge((CommandSender)user);
        InventoryWorkaround.removeItem((Inventory)user.getInventory(), true, new ItemStack(is.getType(), amount, is.getDurability()));
        user.updateInventory();
        user.giveMoney(worth * (double)amount);
        user.sendMessage("\u00a77Sold for \u00a7c" + Util.formatCurrency(worth * (double)amount) + "\u00a77 (" + amount + " items at " + Util.formatCurrency(worth) + " each)");
        logger.log(Level.INFO, user.getDisplayName() + " sold " + is.getType().toString().toLowerCase() + " for \u00a7c" + Util.formatCurrency(worth * (double)amount) + "\u00a77 (" + amount + " items at " + Util.formatCurrency(worth) + " each)");
    }
}

