/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.IEssentialsCommand;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class EssentialsCommand
implements IEssentialsCommand {
    private final String name;
    protected Essentials ess;
    protected static final Logger logger = Logger.getLogger("Minecraft");

    protected EssentialsCommand(String name) {
        this.name = name;
        this.ess = Essentials.getStatic();
    }

    public String getName() {
        return this.name;
    }

    protected User getPlayer(Server server, String[] args, int pos) throws IndexOutOfBoundsException, NoSuchFieldException {
        if (args.length <= pos) {
            throw new IndexOutOfBoundsException("\u00a7cInvalid command syntax. Did you forget an argument?");
        }
        List matches = server.matchPlayer(args[pos]);
        if (matches.size() < 1) {
            throw new NoSuchFieldException("\u00a7cNo matching players could be found.");
        }
        return this.ess.getUser(matches.get(0));
    }

    public final void run(Server server, User user, String commandLabel, Command cmd, String[] args) throws Exception {
        this.run(server, user, commandLabel, args);
    }

    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        this.run(server, (CommandSender)user.getBase(), commandLabel, args);
    }

    public final void run(Server server, CommandSender sender, String commandLabel, Command cmd, String[] args) throws Exception {
        this.run(server, sender, commandLabel, args);
    }

    protected void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        throw new Exception("Only in-game players can use " + commandLabel + ".");
    }

    public static String getFinalArg(String[] args, int start) {
        StringBuilder bldr = new StringBuilder();
        for (int i = start; i < args.length; ++i) {
            if (i != start) {
                bldr.append(" ");
            }
            bldr.append(args[i]);
        }
        return bldr.toString();
    }

    protected void charge(CommandSender sender) throws Exception {
        if (sender instanceof Player) {
            this.ess.getUser((Player)sender).charge(this);
        }
    }
}

