/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop.MinecartMania;

import com.Acrobot.iConomyChestShop.ConfigManager;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaInventory;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaSingleContainer;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaWorld;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MinecartManiaChest
extends MinecartManiaSingleContainer
implements MinecartManiaInventory {
    public static int SPAWN_DELAY = 1000;
    private long lastSpawnTime = -1L;
    private final Location chest;
    private boolean redstonePower;
    private ConcurrentHashMap<String, Object> data = new ConcurrentHashMap();

    public MinecartManiaChest(Chest chest) {
        super(chest.getInventory());
        this.chest = chest.getBlock().getLocation().clone();
        this.setRedstonePower(MinecartManiaWorld.isBlockIndirectlyPowered(chest.getWorld(), this.getX(), this.getY(), this.getZ()));
    }

    public int getX() {
        return this.chest.getBlockX();
    }

    public int getY() {
        return this.chest.getBlockY();
    }

    public int getZ() {
        return this.chest.getBlockZ();
    }

    public World getWorld() {
        return this.chest.getWorld();
    }

    public Location getLocation() {
        return this.chest;
    }

    public Chest getChest() {
        return (Chest)this.chest.getBlock().getState();
    }

    public MinecartManiaChest getNeighborChest() {
        return MinecartManiaChest.getNeighborChest(this.chest.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public static boolean hasNeightborChest(Block block) {
        return MinecartManiaChest.getNeighborChest(block.getWorld(), block.getX(), block.getY(), block.getZ()) != null;
    }

    public static Block getNeightborChestBlock(Block block) {
        return MinecartManiaChest.hasNeightborChest(block) ? MinecartManiaChest.getNeighborChest(block.getWorld(), block.getX(), block.getY(), block.getZ()).getChest().getBlock() : null;
    }

    public static MinecartManiaChest getNeighborChest(World w, int x, int y, int z) {
        if (MinecartManiaWorld.getBlockAt(w, x - 1, y, z).getTypeId() == Material.CHEST.getId()) {
            return MinecartManiaWorld.getMinecartManiaChest((Chest)MinecartManiaWorld.getBlockAt(w, x - 1, y, z).getState());
        }
        if (MinecartManiaWorld.getBlockAt(w, x + 1, y, z).getTypeId() == Material.CHEST.getId()) {
            return MinecartManiaWorld.getMinecartManiaChest((Chest)MinecartManiaWorld.getBlockAt(w, x + 1, y, z).getState());
        }
        if (MinecartManiaWorld.getBlockAt(w, x, y, z - 1).getTypeId() == Material.CHEST.getId()) {
            return MinecartManiaWorld.getMinecartManiaChest((Chest)MinecartManiaWorld.getBlockAt(w, x, y, z - 1).getState());
        }
        if (MinecartManiaWorld.getBlockAt(w, x, y, z + 1).getTypeId() == Material.CHEST.getId()) {
            return MinecartManiaWorld.getMinecartManiaChest((Chest)MinecartManiaWorld.getBlockAt(w, x, y, z + 1).getState());
        }
        return null;
    }

    public Object getDataValue(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public void setDataValue(String key, Object value) {
        if (value == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    @Override
    public boolean addItem(ItemStack item) {
        if (item == null) {
            return true;
        }
        if (item.getTypeId() == Material.AIR.getId()) {
            return false;
        }
        int max = ConfigManager.getBoolean("stackUnstackableItems") ? 64 : item.getType().getMaxStackSize();
        int i = 0;
        while (i < this.size()) {
            if (this.getItem(i) != null && this.getItem(i).getTypeId() == item.getTypeId() && (this.getItem(i).getDurability() == item.getDurability() || this.getItem(i).getDurability() == -1)) {
                if (this.getItem(i).getAmount() + item.getAmount() <= max) {
                    this.setItem(i, new ItemStack(item.getTypeId(), this.getItem(i).getAmount() + item.getAmount(), item.getDurability()));
                    return true;
                }
                int diff = this.getItem(i).getAmount() + item.getAmount() - max;
                this.setItem(i, new ItemStack(item.getTypeId(), max, item.getDurability()));
                item = new ItemStack(item.getTypeId(), diff, item.getDurability());
            }
            ++i;
        }
        int emptySlot = this.firstEmpty();
        int amount = item.getAmount();
        if (emptySlot > -1 && amount <= max) {
            this.setItem(emptySlot, item);
            this.update();
            return true;
        }
        MinecartManiaChest neighbor = this.getNeighborChest();
        if (neighbor != null) {
            if (this.getDataValue("neighbor") == null) {
                neighbor.setDataValue("neighbor", Boolean.TRUE);
                if (this.getNeighborChest().addItem(item)) {
                    this.update();
                    return true;
                }
            } else {
                this.setDataValue("neighbor", null);
            }
        }
        return false;
    }

    @Override
    public boolean removeItem(int type, int amount, short durability) {
        boolean checkDurability = true;
        if (ConfigManager.getBoolean("allowUsedItemsToBeSold") && type >= 256 && type <= 317) {
            checkDurability = false;
        }
        int i = 0;
        while (i < this.size()) {
            if (!(this.getItem(i) == null || this.getItem(i).getTypeId() != type || checkDurability && durability != -1 && this.getItem(i).getDurability() != durability)) {
                if (this.getItem(i).getAmount() - amount > 0) {
                    this.setItem(i, new ItemStack(type, this.getItem(i).getAmount() - amount, durability));
                    this.update();
                    return true;
                }
                if (this.getItem(i).getAmount() - amount == 0) {
                    this.setItem(i, null);
                    this.update();
                    return true;
                }
                amount -= this.getItem(i).getAmount();
                this.setItem(i, null);
            }
            ++i;
        }
        MinecartManiaChest neighbor = this.getNeighborChest();
        if (neighbor != null) {
            if (this.getDataValue("neighbor") == null) {
                neighbor.setDataValue("neighbor", Boolean.TRUE);
                if (neighbor.removeItem(type, amount)) {
                    this.update();
                    return true;
                }
            } else {
                this.setDataValue("neighbor", null);
            }
        }
        return false;
    }

    public void setRedstonePower(boolean redstonePower) {
        this.redstonePower = redstonePower;
    }

    public boolean isRedstonePower() {
        return this.redstonePower;
    }

    public void update() {
        this.getChest().update();
    }

    public String toString() {
        return "[" + this.getX() + ":" + this.getY() + ":" + this.getZ() + "]";
    }

    @Override
    public Inventory getInventory() {
        return this.getChest().getInventory();
    }

    public boolean canSpawnMinecart() {
        if (this.lastSpawnTime == -1L || Math.abs(System.currentTimeMillis() - this.lastSpawnTime) > (long)SPAWN_DELAY) {
            this.lastSpawnTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

