/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop.MinecartMania;

import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaChest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.material.Button;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;

public class MinecartManiaWorld {
    private static ConcurrentHashMap<Location, MinecartManiaChest> chests = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Object> configuration = new ConcurrentHashMap();

    public static MinecartManiaChest getMinecartManiaChest(Chest chest) {
        MinecartManiaChest testChest = chests.get(new Location(chest.getWorld(), (double)chest.getX(), (double)chest.getY(), (double)chest.getZ()));
        if (testChest == null) {
            MinecartManiaChest newChest = new MinecartManiaChest(chest);
            chests.put(new Location(chest.getWorld(), (double)chest.getX(), (double)chest.getY(), (double)chest.getZ()), newChest);
            return newChest;
        }
        if (MinecartManiaWorld.getBlockIdAt(testChest.getWorld(), testChest.getX(), testChest.getY(), testChest.getZ()) == Material.CHEST.getId()) {
            testChest.updateInventory(testChest.getInventory());
            return testChest;
        }
        chests.remove(new Location(chest.getWorld(), (double)chest.getX(), (double)chest.getY(), (double)chest.getZ()));
        return null;
    }

    public static boolean delMinecartManiaChest(Location v) {
        if (chests.containsKey(v)) {
            chests.remove(v);
            return true;
        }
        return false;
    }

    public static ArrayList<MinecartManiaChest> getMinecartManiaChestList() {
        Iterator<Map.Entry<Location, MinecartManiaChest>> i = chests.entrySet().iterator();
        ArrayList<MinecartManiaChest> chestList = new ArrayList<MinecartManiaChest>(chests.size());
        while (i.hasNext()) {
            chestList.add(i.next().getValue());
        }
        return chestList;
    }

    public static Object getConfigurationValue(String key) {
        if (configuration.containsKey(key)) {
            return configuration.get(key);
        }
        return null;
    }

    public static void setConfigurationValue(String key, Object value) {
        if (value == null) {
            configuration.remove(key);
        } else {
            configuration.put(key, value);
        }
    }

    public static ConcurrentHashMap<String, Object> getConfiguration() {
        return configuration;
    }

    public static int getIntValue(Object o) {
        if (o != null && o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public static double getDoubleValue(Object o) {
        if (o != null) {
            if (o instanceof Double) {
                return (Double)o;
            }
            return MinecartManiaWorld.getIntValue(o);
        }
        return 0.0;
    }

    public static int getMaximumMinecartSpeedPercent() {
        return MinecartManiaWorld.getIntValue(MinecartManiaWorld.getConfigurationValue("MaximumMinecartSpeedPercent"));
    }

    public static int getDefaultMinecartSpeedPercent() {
        return MinecartManiaWorld.getIntValue(MinecartManiaWorld.getConfigurationValue("DefaultMinecartSpeedPercent"));
    }

    public static int getMinecartsClearRailsSetting() {
        return MinecartManiaWorld.getIntValue(MinecartManiaWorld.getConfigurationValue("MinecartsClearRails"));
    }

    public static boolean isKeepMinecartsLoaded() {
        Object o = MinecartManiaWorld.getConfigurationValue("KeepMinecartsLoaded");
        if (o != null) {
            return (Boolean)o;
        }
        return false;
    }

    public static boolean isMinecartsKillMobs() {
        Object o = MinecartManiaWorld.getConfigurationValue("MinecartsKillMobs");
        if (o != null) {
            return (Boolean)o;
        }
        return true;
    }

    public static boolean isReturnMinecartToOwner() {
        Object o = MinecartManiaWorld.getConfigurationValue("MinecartsReturnToOwner");
        if (o != null) {
            return (Boolean)o;
        }
        return true;
    }

    public static Block getBlockAt(World w, int x, int y, int z) {
        return w.getBlockAt(x, y, z);
    }

    public static int getBlockIdAt(World w, int x, int y, int z) {
        return w.getBlockTypeIdAt(x, y, z);
    }

    public static void setBlockAt(World w, int type, int x, int y, int z) {
        w.getBlockAt(x, y, z).setTypeId(type);
    }

    public static byte getBlockData(World w, int x, int y, int z) {
        return w.getBlockAt(x, y, z).getData();
    }

    public static void setBlockData(World w, int x, int y, int z, int data) {
        w.getBlockAt(x, y, z).setData((byte)data);
    }

    public static boolean isBlockIndirectlyPowered(World w, int x, int y, int z) {
        return MinecartManiaWorld.getBlockAt(w, x, y, z).isBlockIndirectlyPowered();
    }

    public static boolean isBlockPowered(World w, int x, int y, int z) {
        return MinecartManiaWorld.getBlockAt(w, x, y, z).isBlockPowered();
    }

    public static void setBlockPowered(World w, int x, int y, int z, boolean power) {
        MaterialData md = MinecartManiaWorld.getBlockAt(w, x, y, z).getState().getData();
        byte data = MinecartManiaWorld.getBlockData(w, x, y, z);
        if (MinecartManiaWorld.getBlockAt(w, x, y, z).getTypeId() == Material.DIODE_BLOCK_OFF.getId() && power) {
            MinecartManiaWorld.setBlockAt(w, Material.DIODE_BLOCK_ON.getId(), x, y, z);
            MinecartManiaWorld.setBlockData(w, x, y, z, data);
        } else if (MinecartManiaWorld.getBlockAt(w, x, y, z).getTypeId() == Material.DIODE_BLOCK_ON.getId() && !power) {
            MinecartManiaWorld.setBlockAt(w, Material.DIODE_BLOCK_OFF.getId(), x, y, z);
            MinecartManiaWorld.setBlockData(w, x, y, z, data);
        } else if (md instanceof Lever || md instanceof Button) {
            MinecartManiaWorld.setBlockData(w, x, y, z, (byte)(power ? data | 8 : data & 7));
        }
    }

    public static void setBlockIndirectlyPowered(World w, int x, int y, int z, boolean power) {
        MinecartManiaWorld.setBlockPowered(w, x, y, z, power);
        MinecartManiaWorld.setBlockPowered(w, x - 1, y, z, power);
        MinecartManiaWorld.setBlockPowered(w, x + 1, y, z, power);
        MinecartManiaWorld.setBlockPowered(w, x, y - 1, z, power);
        MinecartManiaWorld.setBlockPowered(w, x, y + 1, z, power);
        MinecartManiaWorld.setBlockPowered(w, x, y, z - 1, power);
        MinecartManiaWorld.setBlockPowered(w, x, y, z + 1, power);
    }
}

