/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.Chests.ChestObject;
import com.Acrobot.iConomyChestShop.ConfigManager;
import com.Acrobot.iConomyChestShop.EconomyManager;
import com.Acrobot.iConomyChestShop.Logging;
import com.Acrobot.iConomyChestShop.SignManager;
import com.Acrobot.iConomyChestShop.iConomyChestShop;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Shop {
    private final ChestObject chest;
    public final String owner;
    private final float buyPrice;
    private final float sellPrice;
    public final ItemStack stock;
    public final int stockAmount;

    Shop(Sign sign, ChestObject obj) {
        this.chest = obj;
        this.owner = SignManager.getOwner(sign);
        this.buyPrice = SignManager.buyPrice(sign);
        this.sellPrice = SignManager.sellPrice(sign);
        this.stock = Basic.getItemStack(sign.getLine(3).replace(":", ";"));
        this.stockAmount = SignManager.getItemAmount(sign);
    }

    public float getBuyPrice() {
        return this.buyPrice == -1.0f ? 0.0f : this.buyPrice;
    }

    public float getSellPrice() {
        return this.sellPrice == -1.0f ? 0.0f : this.sellPrice;
    }

    public boolean buy(Player player) {
        if (this.stock == null) {
            return false;
        }
        if (!this.isSelling()) {
            player.sendMessage(ConfigManager.getLanguage("No_buying_from_this_shop"));
            return false;
        }
        if (!this.playerHasFreeSpace(player)) {
            player.sendMessage(ConfigManager.getLanguage("Your_inventory_is_full"));
            return false;
        }
        if (!this.isAdminShop() && !this.hasEnoughStock()) {
            player.sendMessage(ConfigManager.getLanguage("Shop_is_out_of_stock"));
            if (ConfigManager.getBoolean("showOutOfStock")) {
                String msg = ConfigManager.getLanguage("Your_shop_is_out_of_stock");
                msg = msg.replace("<item>", this.stock.getType().name());
                this.sendMsgToOwner(msg);
            }
            return false;
        }
        if (!this.isAdminShop()) {
            this.chest.removeItem(this.stock, this.stockAmount);
            EconomyManager.add(this.owner, this.getBuyPrice());
        } else {
            String account = ConfigManager.getString("serverAccountName");
            if (account != null && EconomyManager.hasAccount(account)) {
                EconomyManager.add(account, this.getSellPrice());
            }
        }
        this.stock.setAmount(this.stockAmount);
        Basic.addItemToInventory((Inventory)player.getInventory(), this.stock, this.stockAmount);
        player.updateInventory();
        EconomyManager.substract(player.getName(), this.getBuyPrice());
        ConfigManager.buyingString(this.stockAmount, this.stock.getType().name(), this.owner, player, this.getBuyPrice());
        Logging.logToDB(true, this, player);
        return true;
    }

    public boolean sell(Player player) {
        if (this.stock == null) {
            return false;
        }
        if (!this.isBuying()) {
            player.sendMessage(ConfigManager.getLanguage("No_selling_to_this_shop"));
            return false;
        }
        if (Basic.getItemAmountFromInventory((Inventory)player.getInventory(), this.stock) < this.stockAmount) {
            player.sendMessage(ConfigManager.getLanguage("You_have_not_enough_items"));
            return false;
        }
        if (!this.isAdminShop()) {
            if (!this.hasFreeSpace()) {
                player.sendMessage(ConfigManager.getLanguage("Chest_is_full"));
                return false;
            }
            this.chest.addItem(this.stock, this.stockAmount);
            EconomyManager.substract(this.owner, this.getSellPrice());
        } else {
            String account = ConfigManager.getString("serverAccountName");
            if (account != null && EconomyManager.hasAccount(account)) {
                EconomyManager.substract(account, this.getSellPrice());
            }
        }
        Basic.removeItemStackFromInventory((Inventory)player.getInventory(), this.stock, this.stockAmount);
        player.updateInventory();
        EconomyManager.add(player.getName(), this.getSellPrice());
        ConfigManager.sellingString(this.stockAmount, this.stock.getType().name(), this.owner, player, this.getSellPrice());
        Logging.logToDB(false, this, player);
        return true;
    }

    public boolean isAdminShop() {
        return this.owner.toLowerCase().replace(" ", "").equals("adminshop");
    }

    public String shopOwnerName() {
        if (this.isAdminShop()) {
            return ConfigManager.getString("serverAccountName");
        }
        return this.owner;
    }

    private void sendMsgToOwner(String msg) {
        if (this.isAdminShop()) {
            return;
        }
        Player player = iConomyChestShop.getBukkitServer().getPlayer(this.owner);
        if (player == null) {
            return;
        }
        player.sendMessage(msg);
    }

    private boolean hasEnoughStock() {
        return this.chest.hasEnough(this.stock, this.stockAmount);
    }

    private boolean isSelling() {
        return this.buyPrice != 0.0f;
    }

    private boolean isBuying() {
        return this.sellPrice != 0.0f;
    }

    private boolean hasFreeSpace() {
        return this.chest.fits(this.stock, this.stockAmount);
    }

    private boolean playerHasFreeSpace(Player player) {
        return Basic.checkFreeSpace((Inventory)player.getInventory(), this.stock, this.stockAmount);
    }
}

