/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.ConfigManager;
import com.Acrobot.iConomyChestShop.DBqueue;
import com.Acrobot.iConomyChestShop.Logging;
import com.Acrobot.iConomyChestShop.PermissionManager;
import com.Acrobot.iConomyChestShop.SignManager;
import com.Acrobot.iConomyChestShop.StatGenerator;
import com.Acrobot.iConomyChestShop.Transaction;
import com.Acrobot.iConomyChestShop.iConomyChestShopBlockBreak;
import com.Acrobot.iConomyChestShop.iConomyChestShopBlockListener;
import com.Acrobot.iConomyChestShop.iConomyChestShopPlayerListener;
import com.Acrobot.iConomyChestShop.iConomyChestShopPluginListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class iConomyChestShop
extends JavaPlugin {
    private final iConomyChestShopPlayerListener playerListener = new iConomyChestShopPlayerListener();
    private final iConomyChestShopBlockListener blockListener = new iConomyChestShopBlockListener();
    private final iConomyChestShopPluginListener pluginListener = new iConomyChestShopPluginListener();
    private final SignManager signManager = new SignManager();
    private final iConomyChestShopBlockBreak blockBreakListener = new iConomyChestShopBlockBreak();
    private static Server Server = null;
    private static final HashMap<Player, Boolean> sellUsers = new HashMap();

    public void onEnable() {
        int interval;
        Server = this.getServer();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLUGIN_ENABLE, (Listener)this.pluginListener, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.blockBreakListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)this.signManager, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.playerListener, Event.Priority.Highest, (Plugin)this);
        PluginDescriptionFile pdfFile = this.getDescription();
        this.setupDatabaseFile();
        ConfigManager.load();
        if (ConfigManager.getBoolean("useDB")) {
            this.setupDatabase();
            interval = ConfigManager.getInt("intervalBetweenGeneratingTransactionList");
            if (interval == 0) {
                interval = 300;
            }
            this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new DBqueue(), 200L, 200L);
            if (ConfigManager.getBoolean("generateTransactionList")) {
                this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new StatGenerator(), 20L * (long)interval, 20L * (long)interval);
            }
        }
        if ((interval = ConfigManager.getInt("intervalBetweenTransactions")) == 0) {
            interval = 300;
        }
        iConomyChestShopPlayerListener.interval = interval;
        Logging.setPlugin(this);
        StatGenerator.setPlugin(this);
        System.out.println("[" + pdfFile.getName() + "]" + " version " + pdfFile.getVersion() + " initialized!");
    }

    public static boolean enabled(Player player) {
        return sellUsers.containsKey(player);
    }

    private void setupDatabaseFile() {
        File file = new File("ebean.properties");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                System.out.println("[iConomyChestShop] Failed to create ebean.properties file.");
            }
        }
    }

    private void setupDatabase() {
        try {
            this.getDatabase().find(Transaction.class).findRowCount();
        }
        catch (PersistenceException ex) {
            System.out.println("[iConomyChestShop] Installing database for " + this.getDescription().getName() + " due to first time usage.");
            this.installDDL();
        }
    }

    public List<Class<?>> getDatabaseClasses() {
        ArrayList list = new ArrayList();
        list.add(Transaction.class);
        return list;
    }

    public void sellCommand(Player player) {
        if (!iConomyChestShopPlayerListener.canSell(player)) {
            return;
        }
        if (ConfigManager.getBoolean("sell")) {
            sellUsers.put(player, null);
            player.sendMessage(ConfigManager.getLanguage("Mode_changed_to_sell"));
        } else {
            player.sendMessage("[Shop] Selling to shops turned off in the config.");
        }
    }

    public void buyCommand(Player player) {
        if (iConomyChestShop.enabled(player)) {
            sellUsers.remove(player);
            player.sendMessage(ConfigManager.getLanguage("Mode_changed_to_buy"));
        } else {
            player.sendMessage(ConfigManager.getLanguage("Mode_changed_to_buy"));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        PluginDescriptionFile pdfFile = this.getDescription();
        String commandName = cmd.getName().toLowerCase();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (commandName.equals("buy")) {
                this.buyCommand(player);
                return true;
            }
            if (commandName.equals("sell")) {
                this.sellCommand(player);
                return true;
            }
            if (commandName.equals("icsversion")) {
                player.sendMessage("iConomyChestShop's version is: " + pdfFile.getVersion());
                return true;
            }
            if (commandName.equals("chest")) {
                if (args.length != 1) {
                    return false;
                }
                if (args[0].equals("buy")) {
                    this.buyCommand(player);
                    return true;
                }
                if (args[0].equals("sell")) {
                    this.sellCommand(player);
                    return true;
                }
                return false;
            }
            if (commandName.equals("iteminfo")) {
                int id;
                Material mat;
                if (!PermissionManager.hasPermissions(player, "iConomyChestShop.command.iteminfo")) {
                    player.sendMessage("[Permissions]" + ChatColor.RED.toString() + " You can't see item informations!");
                    return true;
                }
                String dmgValue = "";
                if (args.length == 0) {
                    ItemStack itemInHand = player.getItemInHand();
                    mat = itemInHand.getType();
                    id = mat.getId();
                    dmgValue = id >= 256 && id <= 317 ? "" : ";" + itemInHand.getDurability();
                } else if (args.length == 1) {
                    if (Basic.isInt(args[0])) {
                        mat = Material.getMaterial((int)Integer.parseInt(args[0]));
                    } else {
                        try {
                            ItemStack itemStack = Basic.getItemStack(args[0].replace(":", ";"));
                            mat = itemStack.getType();
                            id = mat.getId();
                            dmgValue = id >= 256 && id <= 317 ? "" : ";" + itemStack.getDurability();
                        }
                        catch (Exception ex) {
                            mat = Basic.getMat(args[0]);
                        }
                    }
                } else {
                    return false;
                }
                if (mat == null) {
                    return false;
                }
                String othernames = "";
                if (Basic.OI != null) {
                    Set aliases = Basic.OI.getAliases(String.valueOf(mat.getId()) + dmgValue.replace(":", ";"));
                    for (String alias : aliases) {
                        if (String.valueOf(alias).equalsIgnoreCase(mat.name()) || Basic.isInt(String.valueOf(alias))) continue;
                        othernames = String.valueOf(othernames) + ", " + alias;
                    }
                }
                player.sendMessage(Basic.colorChat(ConfigManager.getLanguage("iteminfo")));
                String msg = "&b" + mat.getId() + (!dmgValue.equals("") ? dmgValue.replace(";", ":") : "") + "&f - " + "&b" + mat.name() + othernames;
                player.sendMessage(Basic.colorChat(msg));
                return true;
            }
            return false;
        }
        return true;
    }

    public static Server getBukkitServer() {
        return Server;
    }

    public static iConomyChestShop getPlugin() {
        return Logging.plugin;
    }

    public void onDisable() {
        DBqueue.saveQueueOnExit();
        this.getServer().getScheduler().cancelAllTasks();
        PluginDescriptionFile pdfFile = this.getDescription();
        System.out.println("[" + pdfFile.getName() + "]" + " version " + pdfFile.getVersion() + " distabled!");
    }
}

