/*
 * Decompiled with CFR 0.152.
 */
package com.nijikokun.register.payment;

import com.nijikokun.register.payment.Method;
import com.nijikokun.register.payment.methods.BOSE;
import com.nijikokun.register.payment.methods.EE17;
import com.nijikokun.register.payment.methods.iCo4;
import com.nijikokun.register.payment.methods.iCo5;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Methods {
    private Method Method = null;
    private Set<Method> Methods = new HashSet<Method>();
    private Set<String> Dependencies = new HashSet<String>();

    public Methods() {
        this.addMethod("iConomy", new iCo4());
        this.addMethod("iConomy", new iCo5());
        this.addMethod("BOSEconomy", new BOSE());
        this.addMethod("Essentials", new EE17());
    }

    public Set<String> getDependencies() {
        return this.Dependencies;
    }

    public Method createMethod(Plugin plugin) {
        for (Method method : this.Methods) {
            if (!method.isCompatible(plugin)) continue;
            method.setPlugin(plugin);
            return method;
        }
        return null;
    }

    private void addMethod(String name, Method method) {
        this.Dependencies.add(name);
        this.Methods.add(method);
    }

    public boolean hasMethod() {
        return this.Method != null;
    }

    public boolean setMethod(Plugin method) {
        if (this.hasMethod()) {
            return true;
        }
        PluginManager manager = method.getServer().getPluginManager();
        Plugin plugin = null;
        for (String name : this.getDependencies()) {
            Method current;
            if (this.hasMethod()) break;
            plugin = method.getDescription().getName().equals(name) ? method : manager.getPlugin(name);
            if (plugin == null || !plugin.isEnabled() || (current = this.createMethod(plugin)) == null) continue;
            this.Method = current;
        }
        return this.hasMethod();
    }

    public Method getMethod() {
        return this.Method;
    }

    public boolean checkDisabled(Plugin method) {
        if (!this.hasMethod()) {
            return true;
        }
        if (this.Method.isCompatible(method)) {
            this.Method = null;
        }
        return this.Method == null;
    }
}

