/*
 * Decompiled with CFR 0.152.
 */
package de.fgtech.pomo4ka.AuthMe.Listener;

import de.fgtech.pomo4ka.AuthMe.AuthMe;
import de.fgtech.pomo4ka.AuthMe.InventoryCache.InventoryArmour;
import de.fgtech.pomo4ka.AuthMe.LoginTimeout.LoginTimeout;
import de.fgtech.pomo4ka.AuthMe.MessageHandler.MessageHandler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class AuthMePlayerListener
extends PlayerListener {
    private final AuthMe plugin;

    public AuthMePlayerListener(AuthMe instance) {
        this.plugin = instance;
    }

    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        String playername = player.getName();
        if (this.plugin.settings.KickNonRegistered() && !this.plugin.datacontroller.isPlayerRegistered(playername)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plugin.messages.getMessage("Kick.NotRegistered"));
        }
        if (this.plugin.playercache.isPlayerAuthenticated(player)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plugin.messages.getMessage("Kick.OtherUserLoggedIn"));
        }
        if (!playername.matches(this.plugin.settings.PlayerNameRegex()) || playername.length() > this.plugin.settings.PlayerNameMaxLength() || playername.length() < this.plugin.settings.PlayerNameMinLength() || playername.equalsIgnoreCase("Player")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plugin.messages.getMessage("Kick.DisallowedCharacters", playername));
        }
    }

    public void onPlayerKick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        if (event.getReason().equals("Logged in from another location.") && this.plugin.playercache.isPlayerAuthenticated(player)) {
            event.setCancelled(true);
        }
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        boolean regged = this.plugin.datacontroller.isPlayerRegistered(player.getName());
        this.plugin.playercache.createCache(player, regged, false);
        if (this.plugin.checkUnrestrictedAccess(player)) {
            this.plugin.playercache.setPlayerAuthenticated(player, true);
        }
        if (!this.plugin.playercache.isPlayerRegistered(player)) {
            if (this.plugin.settings.ForceRegistration()) {
                player.sendMessage(this.plugin.messages.getMessage("JoinMessage.ForceRegistration"));
                player.sendMessage(this.plugin.messages.getMessage("JoinMessage.Command"));
                return;
            }
            player.sendMessage(this.plugin.messages.getMessage("JoinMessage.FreeRegistration"));
            player.sendMessage(this.plugin.messages.getMessage("JoinMessage.Command"));
            return;
        }
        if (this.plugin.settings.LoginSessionsEnabled() && this.plugin.sessionhandler.isSessionValid(player)) {
            this.plugin.performPlayerLogin(player);
            player.sendMessage(this.plugin.messages.getMessage("Sessions.Hint"));
            MessageHandler.showInfo("Player " + player.getName() + " was automatically logged in by session.");
            return;
        }
        if (!this.plugin.invcache.doesCacheExist(player.getName())) {
            ItemStack[] inv = player.getInventory().getContents();
            ItemStack[] arm = player.getInventory().getArmorContents();
            InventoryArmour invarm = new InventoryArmour(inv, arm);
            this.plugin.invcache.createCache(player.getName(), invarm);
        }
        if (player.getHealth() <= 0) {
            this.plugin.invcache.removeCache(player.getName());
            Location spawn = player.getWorld().getSpawnLocation();
            player.teleport(spawn);
        }
        player.getInventory().clear();
        player.getInventory().setHelmet(null);
        player.getInventory().setChestplate(null);
        player.getInventory().setLeggings(null);
        player.getInventory().setBoots(null);
        LoginTimeout.createLoginTimeout(this.plugin, player);
        player.sendMessage(this.plugin.messages.getMessage("Alert.Login"));
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.settings.LoginSessionsEnabled() && this.plugin.playercache.isPlayerAuthenticated(player)) {
            this.plugin.sessionhandler.createSession(player);
        }
        this.plugin.playercache.removeCache(player);
        LoginTimeout.removeLoginTimeout(this.plugin, player);
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location fromLoc = event.getFrom();
        Location toLoc = event.getTo();
        if (fromLoc.getX() == toLoc.getX() && fromLoc.getZ() == toLoc.getZ() && fromLoc.getY() > toLoc.getY()) {
            return;
        }
        if (!this.plugin.checkAuth(player)) {
            if (this.plugin.settings.WalkAroundSpawnEnabled() && !this.plugin.playercache.isPlayerRegistered(player)) {
                Location spawn = player.getWorld().getSpawnLocation();
                int xDiff = spawn.getBlockX() - player.getLocation().getBlockX();
                xDiff = Math.abs(xDiff);
                int zDiff = spawn.getBlockZ() - player.getLocation().getBlockZ();
                zDiff = Math.abs(zDiff);
                int maxRadius = this.plugin.settings.WalkAroundSpawnRadius();
                if (xDiff > maxRadius || zDiff > maxRadius) {
                    Location newLoc = xDiff > maxRadius + 3 || zDiff > maxRadius + 3 ? player.getWorld().getSpawnLocation() : event.getFrom();
                    player.teleport(newLoc.clone());
                    event.setCancelled(true);
                }
                return;
            }
            event.setCancelled(true);
            player.teleport(fromLoc);
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.settings.AllowUnregisteredChat() && !this.plugin.playercache.isPlayerRegistered(player)) {
            return;
        }
        if (!this.plugin.checkAuth(player)) {
            event.setMessage("");
            event.setCancelled(true);
        }
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String commandLabel = event.getMessage().split(" ")[0];
        if (this.plugin.checkAuth(player)) {
            return;
        }
        if (commandLabel.equalsIgnoreCase("/register")) {
            return;
        }
        if (commandLabel.equalsIgnoreCase("/login")) {
            return;
        }
        if (commandLabel.equalsIgnoreCase("/l")) {
            return;
        }
        List<Object> cmdList = new ArrayList();
        if (this.plugin.playercache.isPlayerRegistered(player)) {
            if (!this.plugin.settings.AllowAllowNonLoggedInCommand().isEmpty()) {
                cmdList = this.plugin.settings.AllowAllowNonLoggedInCommand();
            }
        } else if (!this.plugin.settings.AllowAllowNonRegisteredCommand().isEmpty()) {
            cmdList = this.plugin.settings.AllowAllowNonRegisteredCommand();
        }
        if (!cmdList.isEmpty()) {
            for (Object key : cmdList) {
                String cmd = (String)key;
                if (!commandLabel.startsWith("/" + cmd)) continue;
                return;
            }
        }
        event.setMessage("/notloggedin");
        event.setCancelled(true);
    }

    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.checkAuth(player)) {
            event.setCancelled(true);
        }
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.checkAuth(player)) {
            event.setCancelled(true);
        }
    }
}

