/*
 * Decompiled with CFR 0.152.
 */
package de.fgtech.pomo4ka.AuthMe.PlayerCache;

import de.fgtech.pomo4ka.AuthMe.PlayerCache.PlayerData;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class PlayerCache {
    private Map<Player, PlayerData> playerDatatable = new HashMap<Player, PlayerData>();

    public void createCache(Player player, boolean registered, boolean authenticated) {
        if (!this.playerDatatable.containsKey(player)) {
            PlayerData data = new PlayerData(registered, authenticated);
            this.playerDatatable.put(player, data);
        }
    }

    public void removeCache(Player player) {
        if (this.playerDatatable.containsKey(player)) {
            this.playerDatatable.remove(player);
        }
    }

    public void recreateCache(Player player) {
        this.removeCache(player);
        this.createCache(player, false, false);
    }

    private PlayerData getPlayerData(Player player) {
        if (this.playerDatatable.containsKey(player)) {
            return this.playerDatatable.get(player);
        }
        return null;
    }

    public boolean isPlayerInCache(Player player) {
        return this.playerDatatable.containsKey(player);
    }

    public void setPlayerRegistered(Player player, boolean newvalue) {
        this.getPlayerData(player).setRegistered(newvalue);
    }

    public boolean isPlayerRegistered(Player player) {
        return this.isPlayerInCache(player) ? this.getPlayerData(player).isRegistered() : false;
    }

    public void setPlayerAuthenticated(Player player, boolean newvalue) {
        this.getPlayerData(player).setAuthenticated(newvalue);
    }

    public boolean isPlayerAuthenticated(Player player) {
        return this.isPlayerInCache(player) ? this.getPlayerData(player).isAuthenticated() : false;
    }

    public long getLastAlert(Player player) {
        return this.getPlayerData(player).getLastAlert();
    }

    public void setLastAlertToNow(Player player) {
        this.getPlayerData(player).setLastAlertToNow();
    }

    public boolean isAlertNeeded(Player player, int intervall) {
        long lastAlert = this.getLastAlert(player);
        long timeDiff = System.currentTimeMillis() - lastAlert;
        if (lastAlert == 0L || timeDiff > (long)(intervall * 1000)) {
            this.setLastAlertToNow(player);
            return true;
        }
        return false;
    }
}

