/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import me.taylorkelly.bigbrother.BBLogging;

public class PropertiesFile {
    private HashMap<String, PropertiesEntry> map;
    private File file;
    private boolean modified;

    public PropertiesFile(File file) {
        this.file = file;
        this.map = new HashMap();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            Scanner scan = new Scanner(file);
            while (scan.hasNextLine()) {
                String key;
                String line = scan.nextLine();
                if (!line.contains("=")) continue;
                int equals = line.indexOf(61);
                int commentIndex = line.length();
                if (line.contains("#")) {
                    commentIndex = line.indexOf(35);
                }
                if ((key = line.substring(0, equals).trim()).equals("")) continue;
                String value = line.substring(equals + 1, commentIndex).trim();
                String comment = "";
                if (commentIndex < line.length() - 1) {
                    comment = line.substring(commentIndex + 1, line.length()).trim();
                }
                this.map.put(key, new PropertiesEntry(value, comment));
            }
        }
        catch (FileNotFoundException e) {
            BBLogging.severe("Cannot read file " + file.getName());
        }
        catch (IOException e) {
            BBLogging.severe("Cannot create file " + file.getName());
        }
    }

    public boolean getBoolean(String key, Boolean defaultValue, String defaultComment) {
        if (this.map.containsKey(key)) {
            return Boolean.parseBoolean(this.map.get((Object)key).value);
        }
        this.map.put(key, new PropertiesEntry(defaultValue.toString(), defaultComment));
        this.modified = true;
        return defaultValue;
    }

    public String getString(String key, String defaultValue, String defaultComment) {
        if (this.map.containsKey(key)) {
            return this.map.get((Object)key).value;
        }
        this.map.put(key, new PropertiesEntry(defaultValue, defaultComment));
        this.modified = true;
        return defaultValue;
    }

    public int getInt(String key, Integer defaultValue, String defaultComment) {
        if (this.map.containsKey(key)) {
            try {
                return Integer.parseInt(this.map.get((Object)key).value);
            }
            catch (Exception e) {
                BBLogging.warning("Trying to get Integer from " + key + ": " + this.map.get((Object)key).value);
                return defaultValue;
            }
        }
        this.map.put(key, new PropertiesEntry(defaultValue.toString(), defaultComment));
        this.modified = true;
        return defaultValue;
    }

    public long getLong(String key, Long defaultValue, String defaultComment) {
        if (this.map.containsKey(key)) {
            try {
                return Long.parseLong(this.map.get((Object)key).value);
            }
            catch (Exception e) {
                BBLogging.warning("Trying to get Long from " + key + ": " + this.map.get((Object)key).value);
                return defaultValue;
            }
        }
        this.map.put(key, new PropertiesEntry(defaultValue.toString(), defaultComment));
        this.modified = true;
        return defaultValue;
    }

    public double getDouble(String key, Double defaultValue, String defaultComment) {
        if (this.map.containsKey(key)) {
            try {
                return Double.parseDouble(this.map.get((Object)key).value);
            }
            catch (Exception e) {
                BBLogging.warning("Trying to get Double from " + key + ": " + this.map.get((Object)key).value);
                return defaultValue;
            }
        }
        this.map.put(key, new PropertiesEntry(defaultValue.toString(), defaultComment));
        this.modified = true;
        return defaultValue;
    }

    public void setDouble(String key, Double globalMemory, String defaultComment) {
        if (this.map.containsKey(key)) {
            PropertiesEntry entry = this.map.get(key);
            entry.value = globalMemory.toString();
        } else {
            this.map.put(key, new PropertiesEntry(globalMemory.toString(), defaultComment));
        }
        this.modified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.modified) {
            return;
        }
        BufferedWriter bwriter = null;
        OutputStreamWriter fwriter = null;
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            fwriter = new FileWriter(this.file);
            bwriter = new BufferedWriter(fwriter);
            for (Map.Entry<String, PropertiesEntry> entry : this.map.entrySet()) {
                StringBuilder builder = new StringBuilder();
                builder.append(entry.getKey());
                builder.append(" = ");
                builder.append(entry.getValue().value);
                if (!entry.getValue().comment.equals("")) {
                    builder.append("   #");
                    builder.append(entry.getValue().comment);
                }
                bwriter.write(builder.toString());
                bwriter.newLine();
            }
            bwriter.flush();
        }
        catch (IOException e) {
            BBLogging.severe("IO Exception with file " + this.file.getName());
        }
        finally {
            try {
                if (bwriter != null) {
                    bwriter.flush();
                    bwriter.close();
                }
                if (fwriter != null) {
                    fwriter.close();
                }
            }
            catch (IOException e) {
                BBLogging.severe("IO Exception with file " + this.file.getName() + " (on close)");
            }
        }
    }

    private static class PropertiesEntry {
        public String value;
        public String comment;

        public PropertiesEntry(String value, String comment) {
            this.value = value;
            this.comment = comment;
        }
    }
}

