/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.finder;

import java.util.ArrayList;
import java.util.HashMap;
import me.taylorkelly.bigbrother.BigBrother;
import me.taylorkelly.bigbrother.WorldManager;
import me.taylorkelly.bigbrother.finder.HistoryLog;
import me.taylorkelly.bigbrother.finder.HistoryStick;
import me.taylorkelly.bigbrother.finder.StickMode;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Sticker {
    private HashMap<String, StickMode> playerModes;
    private ArrayList<Class<? extends StickMode>> modes;
    private WorldManager manager;

    public Sticker(Server server, WorldManager manager) {
        this.manager = manager;
        this.playerModes = new HashMap();
        this.modes = new ArrayList();
        this.modes.add(HistoryStick.class);
        this.modes.add(HistoryLog.class);
    }

    public void setMode(Player player, int i) {
        if (i == 0 && this.playerModes.containsKey(player.getName())) {
            player.sendMessage(BigBrother.premessage + "Turning off SuperStick");
            StickMode mode = this.playerModes.remove(player.getName());
            mode.disable(player);
            return;
        }
        if (--i < 0 || i >= this.modes.size()) {
            player.sendMessage(BigBrother.premessage + (i + 1) + " is out of SuperStick range. Setting to 1");
            i = 0;
        }
        try {
            if (this.playerModes.containsKey(player.getName())) {
                this.playerModes.get(player.getName()).disable(player);
            }
            this.playerModes.put(player.getName(), this.modes.get(i).newInstance());
            this.playerModes.get(player.getName()).initialize(player);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public String descMode(Player player) {
        if (this.playerModes.containsKey(player.getName())) {
            return this.playerModes.get(player.getName()).getDescription();
        }
        return null;
    }

    public boolean hasStick(Player player, ItemStack itemStack) {
        if (this.playerModes.containsKey(player.getName())) {
            return this.playerModes.get(player.getName()).usesStick(itemStack);
        }
        return false;
    }

    private void blockInfo(Player player, Block block) {
        if (this.playerModes.containsKey(player.getName())) {
            StickMode mode = this.playerModes.get(player.getName());
            ArrayList<String> info = mode.getInfoOnBlock(block, this.manager);
            for (String msg : info) {
                player.sendMessage(msg);
            }
        }
    }

    public void stick(Player player, Block block) {
        this.blockInfo(player, block);
        if (this.playerModes.containsKey(player.getName())) {
            StickMode mode = this.playerModes.get(player.getName());
            mode.update(player);
        }
    }

    public boolean rightClickStick(Player player) {
        if (this.playerModes.containsKey(player.getName())) {
            StickMode mode = this.playerModes.get(player.getName());
            return mode.rightClickStick();
        }
        return false;
    }
}

