/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.listeners;

import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBPermissions;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.BigBrother;
import me.taylorkelly.bigbrother.datablock.BrokenBlock;
import me.taylorkelly.bigbrother.datablock.Chat;
import me.taylorkelly.bigbrother.datablock.Command;
import me.taylorkelly.bigbrother.datablock.Disconnect;
import me.taylorkelly.bigbrother.datablock.Login;
import me.taylorkelly.bigbrother.datablock.PlacedBlock;
import me.taylorkelly.bigbrother.datablock.Teleport;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerItemEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerMoveEvent;

public class BBPlayerListener
extends PlayerListener {
    private BigBrother plugin;

    public BBPlayerListener(BigBrother plugin) {
        this.plugin = plugin;
    }

    public void onPlayerCommandPreprocess(PlayerChatEvent event) {
        Player player = event.getPlayer();
        if (BBSettings.commands && this.plugin.watching(player)) {
            Command dataBlock = new Command(player, event.getMessage(), player.getWorld().getName());
            dataBlock.send();
        }
    }

    public void onPlayerJoin(PlayerEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.haveSeen(player)) {
            this.plugin.markSeen(player);
            if (BBSettings.autoWatch) {
                this.plugin.watchPlayer(player);
            }
        }
        if (BBSettings.login && this.plugin.watching(player)) {
            Login dataBlock = new Login(player, player.getWorld().getName());
            dataBlock.send();
        }
        BBLogging.debug(player.getName() + " has Permissions: ");
        BBLogging.debug("- Watching privileges: " + BBPermissions.watch(player));
        BBLogging.debug("- Info privileges: " + BBPermissions.info(player));
        BBLogging.debug("- Rollback privileges: " + BBPermissions.rollback(player));
        BBLogging.debug("- Cleansing privileges: " + BBPermissions.cleanse(player));
    }

    public void onPlayerQuit(PlayerEvent event) {
        Player player = event.getPlayer();
        if (BBSettings.disconnect && this.plugin.watching(player)) {
            Disconnect dataBlock = new Disconnect(player.getName(), player.getLocation(), player.getWorld().getName());
            dataBlock.send();
        }
    }

    public void onPlayerTeleport(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        Player player = event.getPlayer();
        if (BBSettings.teleport && this.plugin.watching(player) && this.distance(from, to) > 5.0 && !event.isCancelled()) {
            Teleport dataBlock = new Teleport(player.getName(), event.getTo());
            dataBlock.send();
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        if (BBSettings.chat && this.plugin.watching(player)) {
            Chat dataBlock = new Chat(player, event.getMessage(), player.getWorld().getName());
            dataBlock.send();
        }
    }

    public void onPlayerItem(PlayerItemEvent event) {
        if (BBSettings.blockPlace && this.plugin.watching(event.getPlayer()) && !event.isCancelled()) {
            block0 : switch (event.getMaterial()) {
                case LAVA_BUCKET: {
                    int x = event.getBlockClicked().getX() + event.getBlockFace().getModX();
                    int y = event.getBlockClicked().getY() + event.getBlockFace().getModY();
                    int z = event.getBlockClicked().getZ() + event.getBlockFace().getModZ();
                    int type = Material.LAVA.getId();
                    World world = event.getBlockClicked().getWorld();
                    PlacedBlock dataBlock = new PlacedBlock(event.getPlayer().getName(), world.getName(), x, y, z, type, 0);
                    dataBlock.send();
                    break;
                }
                case WATER_BUCKET: {
                    int x = event.getBlockClicked().getX() + event.getBlockFace().getModX();
                    int y = event.getBlockClicked().getY() + event.getBlockFace().getModY();
                    int z = event.getBlockClicked().getZ() + event.getBlockFace().getModZ();
                    int type = Material.WATER.getId();
                    World world = event.getBlockClicked().getWorld();
                    PlacedBlock dataBlock = new PlacedBlock(event.getPlayer().getName(), world.getName(), x, y, z, type, 0);
                    dataBlock.send();
                    break;
                }
                case SIGN: {
                    int type;
                    int x = event.getBlockClicked().getX() + event.getBlockFace().getModX();
                    int y = event.getBlockClicked().getY() + event.getBlockFace().getModY();
                    int z = event.getBlockClicked().getZ() + event.getBlockFace().getModZ();
                    World world = event.getBlockClicked().getWorld();
                    int data = 0;
                    switch (event.getBlockFace()) {
                        case UP: {
                            type = Material.SIGN_POST.getId();
                            break;
                        }
                        case NORTH: {
                            data = 4;
                            type = Material.WALL_SIGN.getId();
                            break;
                        }
                        case SOUTH: {
                            data = 5;
                            type = Material.WALL_SIGN.getId();
                            break;
                        }
                        case EAST: {
                            data = 2;
                            type = Material.WALL_SIGN.getId();
                            break;
                        }
                        case WEST: {
                            data = 3;
                            type = Material.WALL_SIGN.getId();
                            break;
                        }
                        default: {
                            type = Material.SIGN.getId();
                        }
                    }
                    PlacedBlock dataBlock = new PlacedBlock(event.getPlayer().getName(), world.getName(), x, y, z, type, (byte)data);
                    dataBlock.send();
                    break;
                }
                case BUCKET: {
                    World world = event.getBlockClicked().getWorld();
                    switch (event.getBlockClicked().getType()) {
                        case STATIONARY_LAVA: 
                        case LAVA: {
                            int x = event.getBlockClicked().getX();
                            int y = event.getBlockClicked().getY();
                            int z = event.getBlockClicked().getZ();
                            int type = Material.LAVA.getId();
                            BrokenBlock dataBlock2 = new BrokenBlock(event.getPlayer().getName(), world.getName(), x, y, z, type, 0);
                            dataBlock2.send();
                            break block0;
                        }
                        case STATIONARY_WATER: 
                        case WATER: {
                            int x = event.getBlockClicked().getX();
                            int y = event.getBlockClicked().getY();
                            int z = event.getBlockClicked().getZ();
                            int type = Material.WATER.getId();
                            BrokenBlock dataBlock2 = new BrokenBlock(event.getPlayer().getName(), world.getName(), x, y, z, type, 0);
                            dataBlock2.send();
                        }
                    }
                }
            }
        }
    }

    private double distance(Location from, Location to) {
        return Math.sqrt(Math.pow(from.getX() - to.getX(), 2.0) + Math.pow(from.getY() - to.getY(), 2.0) + Math.pow(from.getZ() - to.getZ(), 2.0));
    }
}

