/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.actions;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutor;
import cc.co.evenprime.bukkit.nocheat.actions.ActionList;
import cc.co.evenprime.bukkit.nocheat.actions.ActionManager;
import cc.co.evenprime.bukkit.nocheat.actions.ConsoleCommandSender;
import cc.co.evenprime.bukkit.nocheat.actions.history.ActionHistory;
import cc.co.evenprime.bukkit.nocheat.actions.types.Action;
import cc.co.evenprime.bukkit.nocheat.actions.types.ConsolecommandAction;
import cc.co.evenprime.bukkit.nocheat.actions.types.LogAction;
import cc.co.evenprime.bukkit.nocheat.actions.types.SpecialAction;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.log.LogLevel;
import cc.co.evenprime.bukkit.nocheat.log.LogManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ActionExecutorWithHistory
implements ActionExecutor {
    private final Map<Player, ActionHistory> actionHistory = new HashMap<Player, ActionHistory>();
    private final ActionManager actionManager;
    private final LogManager log;
    private final ConsoleCommandSender ccsender;

    public ActionExecutorWithHistory(NoCheat plugin) {
        this.actionManager = plugin.getActionManager();
        this.log = plugin.getLogManager();
        this.ccsender = new ConsoleCommandSender(plugin.getServer());
    }

    @Override
    public boolean executeActions(Player player, ActionList actions, int violationLevel, HashMap<String, String> hashMap, ConfigurationCache cc) {
        boolean special = false;
        for (String a : actions.getActions(violationLevel)) {
            Action ac = this.actionManager.getActionByName(a);
            HashMap<String, String> map = null;
            if (ac != null) {
                if (!this.getHistory(player).executeAction(ac, System.currentTimeMillis())) continue;
                if (ac instanceof LogAction) {
                    map = this.generateHashMap(player, violationLevel, hashMap);
                    LogAction l = (LogAction)ac;
                    this.log.log(l.level, l.getLogMessage(map), cc);
                    continue;
                }
                if (ac instanceof SpecialAction) {
                    special = true;
                    continue;
                }
                if (!(ac instanceof ConsolecommandAction)) continue;
                map = this.generateHashMap(player, violationLevel, hashMap);
                this.executeConsoleCommand(((ConsolecommandAction)ac).getCommand(map));
                continue;
            }
            this.log.logToConsole(LogLevel.HIGH, "NoCheat: Couldn't find action " + a + ". You need to define it properly to use it in your config file!");
        }
        return special;
    }

    private HashMap<String, String> generateHashMap(Player player, double violationLevel, HashMap<String, String> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("\\[player\\]", player.getName());
        Location l = player.getLocation();
        newMap.put("\\[location\\]", String.format(Locale.US, "%.2f,%.2f,%.2f", l.getX(), l.getY(), l.getZ()));
        newMap.put("\\[world\\]", player.getWorld().getName());
        newMap.put("\\[violations\\]", String.format(Locale.US, "%.2f", violationLevel));
        newMap.putAll(map);
        return newMap;
    }

    private ActionHistory getHistory(Player player) {
        ActionHistory history = this.actionHistory.get(player);
        if (history == null) {
            history = new ActionHistory();
            this.actionHistory.put(player, history);
        }
        return history;
    }

    private void executeConsoleCommand(String command) {
        this.ccsender.executeConsoleCommand(command);
    }
}

