/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.checks.blockbreak;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.checks.blockbreak.DirectionCheck;
import cc.co.evenprime.bukkit.nocheat.checks.blockbreak.ReachCheck;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.BlockBreakData;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class BlockBreakCheck {
    private final ReachCheck reachCheck;
    private final DirectionCheck directionCheck;

    public BlockBreakCheck(NoCheat plugin) {
        this.reachCheck = new ReachCheck(plugin);
        this.directionCheck = new DirectionCheck(plugin);
    }

    public boolean check(Player player, Block brokenBlock, BlockBreakData data, ConfigurationCache cc) {
        boolean direction;
        boolean cancel = false;
        boolean reach = cc.blockbreak.reachCheck && !player.hasPermission("nocheat.checks.blockbreak.reach");
        boolean bl = direction = cc.blockbreak.directionCheck && !player.hasPermission("nocheat.checks.blockbreak.direction");
        if ((reach || direction) && brokenBlock != null) {
            Location eyes = player.getEyeLocation();
            double x1 = (double)brokenBlock.getX() - eyes.getX() - 0.5;
            double y1 = (double)brokenBlock.getY() - eyes.getY() - 0.5;
            double z1 = (double)brokenBlock.getZ() - eyes.getZ() - 0.5;
            double factor = new Vector(x1 + 1.0, y1 + 1.0, z1 + 1.0).length();
            if (reach) {
                cancel = this.reachCheck.check(player, factor, data, cc);
            }
            if (!cancel && direction && !brokenBlock.getLocation().equals((Object)data.instaBrokeBlockLocation)) {
                cancel = this.directionCheck.check(player, factor, x1, y1, z1, data, cc);
            }
        }
        return cancel;
    }
}

