/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.events;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.checks.blockbreak.BlockBreakCheck;
import cc.co.evenprime.bukkit.nocheat.config.ConfigurationManager;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.BlockBreakData;
import cc.co.evenprime.bukkit.nocheat.data.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class BlockBreakEventManager
extends BlockListener {
    private final BlockBreakCheck blockBreakCheck;
    private final DataManager data;
    private final ConfigurationManager config;

    public BlockBreakEventManager(NoCheat plugin) {
        this.data = plugin.getDataManager();
        this.config = plugin.getConfigurationManager();
        this.blockBreakCheck = new BlockBreakCheck(plugin);
        PluginManager pm = Bukkit.getServer().getPluginManager();
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)this, Event.Priority.Lowest, (Plugin)plugin);
        pm.registerEvent(Event.Type.BLOCK_DAMAGE, (Listener)this, Event.Priority.Monitor, (Plugin)plugin);
    }

    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ConfigurationCache cc = this.config.getConfigurationCacheForWorld(player.getWorld().getName());
        if (cc.blockbreak.check && !player.hasPermission("nocheat.checks.blockbreak.*")) {
            boolean cancel = false;
            BlockBreakData data = this.data.getBlockBreakData(player);
            cancel = this.blockBreakCheck.check(player, event.getBlock(), data, cc);
            if (cancel) {
                event.setCancelled(true);
            }
        }
    }

    public void onBlockDamage(BlockDamageEvent event) {
        if (!event.isCancelled() && !event.getInstaBreak()) {
            return;
        }
        Player player = event.getPlayer();
        BlockBreakData data = this.data.getBlockBreakData(player);
        data.instaBrokeBlockLocation = event.getBlock().getLocation();
    }
}

