/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.wizard;

import cc.co.evenprime.bukkit.nocheat.DefaultConfiguration;
import cc.co.evenprime.bukkit.nocheat.config.ConfigurationManager;
import cc.co.evenprime.bukkit.nocheat.config.tree.ConfigurationTree;
import cc.co.evenprime.bukkit.nocheat.wizard.gui.ConfigurationTreeGui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Wizard
extends JFrame {
    private static final long serialVersionUID = 8798111079958773207L;
    public static final Color disabled = Color.GRAY;
    public static final Color enabled = Color.BLACK;
    private final JTabbedPane tabs = new JTabbedPane();
    private final Map<String, File> worldFiles = ConfigurationManager.getWorldSpecificConfigFiles("NoCheat");
    private final Map<String, ConfigurationTree> worldTrees = new HashMap<String, ConfigurationTree>();

    public static void main(String[] args) {
        Wizard w = new Wizard();
        w.setVisible(true);
    }

    public Wizard() {
        ConfigurationTree globalTree;
        File globalConfig = ConfigurationManager.getGlobalConfigFile("NoCheat");
        try {
            globalTree = ConfigurationManager.createFullConfigurationTree(DefaultConfiguration.buildDefaultConfigurationTree(), globalConfig);
        }
        catch (Exception e) {
            System.out.println("NoCheat: Couldn't use existing global config file " + globalConfig + ", creating a new file.");
            globalTree = DefaultConfiguration.buildDefaultConfigurationTree();
        }
        this.worldTrees.put(null, globalTree);
        for (String worldName : this.worldFiles.keySet()) {
            try {
                ConfigurationTree worldTree = ConfigurationManager.createPartialConfigurationTree(globalTree, this.worldFiles.get(worldName));
                this.worldTrees.put(worldName, worldTree);
            }
            catch (Exception e) {
                System.out.println("NoCheat: Couldn't read existing world-specific config file for world " + worldName);
                this.worldFiles.remove(worldName);
            }
        }
        this.worldFiles.put(null, globalConfig);
        this.setup();
    }

    private void setup() {
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        JButton saveAllButton = new JButton("Save All");
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ((Wizard_JPanel)Wizard.this.tabs.getSelectedComponent()).refresh();
            }
        });
        Wizard_JPanel global = new Wizard_JPanel(this.worldTrees.get(null));
        this.tabs.addTab("Global Settings", null, global, "The settings valid for all worlds, unless a specific setting overrides them.");
        for (String name : this.worldTrees.keySet()) {
            if (name == null) continue;
            Wizard_JPanel world = new Wizard_JPanel(this.worldTrees.get(name));
            this.tabs.addTab(String.valueOf(name) + " Settings", null, world, "Some world-specific settings.");
        }
        saveAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (String worldName : Wizard.this.worldTrees.keySet()) {
                    ConfigurationManager.writeConfigFile((File)Wizard.this.worldFiles.get(worldName), (ConfigurationTree)Wizard.this.worldTrees.get(worldName));
                }
                ConfigurationManager.writeDescriptionFile(ConfigurationManager.getDescriptionFile("NoCheat"), (ConfigurationTree)Wizard.this.worldTrees.get(null));
                DefaultConfiguration.writeDefaultActionFile(ConfigurationManager.getDefaultActionFile("NoCheat"));
                DefaultConfiguration.writeActionFile(ConfigurationManager.getActionFile("NoCheat"));
                JOptionPane.showMessageDialog(null, "Saved All");
            }
        });
        saveAllButton.setAlignmentY(0.0f);
        this.add((Component)saveAllButton, "South");
        this.pack();
        this.setSize(1000, 700);
        this.setTitle("NoCheat configuration utility");
        this.add((Component)this.tabs, "Center");
    }

    private class Wizard_JPanel
    extends JPanel {
        private static final long serialVersionUID = 5748088661296418403L;
        private final JPanel inside;
        private ConfigurationTree tree;

        private Wizard_JPanel(ConfigurationTree tree) {
            JScrollPane scrollPane = new JScrollPane();
            this.inside = new JPanel();
            this.tree = tree;
            scrollPane.setViewportView(this.inside);
            this.setLayout(new BorderLayout());
            this.inside.setLayout(new BoxLayout(this.inside, 1));
            ConfigurationTree modelRoot = tree;
            ConfigurationTreeGui guiRoot = new ConfigurationTreeGui(modelRoot);
            this.inside.add(guiRoot);
            this.add((Component)scrollPane, "Center");
        }

        private void refresh() {
            this.inside.removeAll();
            this.inside.add(new ConfigurationTreeGui(this.tree));
        }
    }
}

