/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.wizard.gui;

import cc.co.evenprime.bukkit.nocheat.Explainations;
import cc.co.evenprime.bukkit.nocheat.config.tree.BooleanOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ChildOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.Option;
import cc.co.evenprime.bukkit.nocheat.config.tree.ParentOption;
import cc.co.evenprime.bukkit.nocheat.wizard.gui.ChildOptionGui;
import cc.co.evenprime.bukkit.nocheat.wizard.gui.ChildOptionGuiFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ParentOptionGui
extends JPanel {
    private static final long serialVersionUID = 5277750257203546802L;
    private final ParentOption option;
    private final ParentOption defaults;

    public ParentOptionGui(ParentOption option, ParentOption defaults) {
        this.option = option;
        this.defaults = defaults;
        this.recreateContent();
    }

    void recreateContent() {
        this.removeAll();
        if (this.option.getIdentifier().length() > 0) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.BLACK), "  " + this.option.getIdentifier() + ":  "), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        }
        this.setLayout(new GridBagLayout());
        int line = 0;
        boolean hideNonMasterOptions = false;
        for (Option o : this.option.getChildOptions()) {
            BooleanOption b2;
            if (!(o instanceof BooleanOption)) continue;
            BooleanOption b = (BooleanOption)o;
            if (b.isMaster() && b.isActive() && !b.getBooleanValue()) {
                hideNonMasterOptions = true;
                continue;
            }
            if (!b.isMaster() || b.isActive() || (b2 = (BooleanOption)this.defaults.getChild(b.getIdentifier())) == null || b2.getBooleanValue()) continue;
            hideNonMasterOptions = true;
        }
        for (Option o : this.option.getChildOptions()) {
            if (hideNonMasterOptions && (!(o instanceof BooleanOption) || !((BooleanOption)o).isMaster())) continue;
            if (this.defaults != null) {
                this.add(o, this.defaults.getChild(o.getIdentifier()), line);
                ++line;
                continue;
            }
            this.add(o, null, line);
            ++line;
        }
        this.revalidate();
    }

    private void add(Option child, Option childDefault, int line) {
        if (child instanceof ParentOption) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = line;
            c.gridwidth = 5;
            c.anchor = 17;
            c.ipadx = 2;
            c.ipady = 15;
            c.weightx = 1.0;
            c.fill = 2;
            this.add((Component)new ParentOptionGui((ParentOption)child, (ParentOption)childDefault), c);
        } else if (child instanceof ChildOption) {
            JLabel id = new JLabel(String.valueOf(child.getIdentifier()) + " :  ");
            ChildOptionGui tmp = ChildOptionGuiFactory.create(child, childDefault, this);
            JButton defaults = this.createAddRemoveButton(this, tmp);
            JButton help = this.createHelpButton(child.getFullIdentifier());
            if (!tmp.isActive()) {
                id.setEnabled(false);
            }
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 18;
            c.ipadx = 2;
            c.insets = new Insets(0, 1, 0, 1);
            if (childDefault != null) {
                this.add((Component)defaults, c);
                ++c.gridx;
            }
            this.add((Component)id, c);
            ++c.gridx;
            this.add((Component)tmp, c);
            ++c.gridx;
            c.ipadx = 2;
            this.add((Component)help, c);
            ++c.gridx;
            c.gridwidth = 5 - c.gridx + 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.add(Box.createHorizontalGlue(), c);
        } else {
            throw new RuntimeException("Unknown Option " + child);
        }
    }

    private JButton createAddRemoveButton(final ParentOptionGui container, final ChildOptionGui option) {
        final JButton addRemove = new JButton("+");
        addRemove.setToolTipText("Allow setting custom options for this world.");
        if (option.isActive()) {
            addRemove.setText("-");
            addRemove.setToolTipText("Use global settings instead of these custom options.");
        }
        addRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (addRemove.getText().equals("+")) {
                    option.setActive(true);
                    addRemove.setText("-");
                    addRemove.setToolTipText("Use global settings instead.");
                } else {
                    option.setActive(false);
                    addRemove.setText("+");
                    addRemove.setToolTipText("Allow setting custom options for this world.");
                }
                container.recreateContent();
            }
        });
        addRemove.setMargin(new Insets(0, 0, 0, 0));
        return addRemove;
    }

    private JButton createHelpButton(final String identifier) {
        JButton help = new JButton("?");
        help.setToolTipText("Show help. Usually some instructions or further information about this option.");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(null, Explainations.get(identifier), "Description of " + identifier, 1);
            }
        });
        help.setMargin(new Insets(0, 0, 0, 0));
        return help;
    }
}

