/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.ACCommand;
import be.Balor.Tools.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerLocation
extends ACCommand {
    public PlayerLocation() {
        this.permNode = "admincmd.player.loc";
        this.cmdName = "bal_playerloc";
        this.other = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(CommandSender sender, String ... args) {
        String msg;
        Location loc;
        if (args.length == 0) {
            if (!Utils.isPlayer(sender)) return;
            loc = ((Player)sender).getLocation();
            msg = "You are";
        } else {
            try {
                loc = sender.getServer().getPlayer(args[0]).getLocation();
                msg = sender.getServer().getPlayer(args[0]).getName() + " is";
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Player " + ChatColor.WHITE + args[0] + ChatColor.RED + " not found!");
                return;
            }
        }
        sender.sendMessage(loc.getBlockX() + " N, " + loc.getBlockZ() + " E, " + loc.getBlockY() + " H");
        String[] facing = new String[]{"W", "NW", "N", "NE", "E", "SE", "S", "SW"};
        double yaw = ((double)loc.getYaw() + 22.5) % 360.0;
        if (yaw < 0.0) {
            yaw += 360.0;
        }
        sender.sendMessage(msg + " facing " + ChatColor.RED + facing[(int)(yaw / 45.0)]);
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

