/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.bukkit.AdminCmd;

import be.Balor.Manager.CommandManager;
import be.Balor.Manager.ExtendedConfiguration;
import be.Balor.Manager.LocaleManager;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.BlockRemanence;
import be.Balor.Tools.FilesManager;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.config.Configuration;

public class ACHelper {
    private HashMap<Material, String[]> materialsColors;
    private List<Integer> listOfPossibleRepair;
    private FilesManager fManager;
    private List<Integer> blacklist;
    private AdminCmd pluginInstance;
    EnumMap<Type, ConcurrentMap<String, Object>> storedTypeValues = new EnumMap(Type.class);
    private ConcurrentMap<String, MaterialContainer> alias = new MapMaker().makeMap();
    private HashMap<String, List<MaterialContainer>> kits = new HashMap();
    private ConcurrentMap<String, ConcurrentMap<String, Location>> locations = new MapMaker().makeMap();
    private Set<String> warpList = new HashSet<String>();
    private ConcurrentMap<String, Set<String>> homeList = new MapMaker().softValues().expiration(15L, TimeUnit.MINUTES).makeMap();
    private static ACHelper instance = null;
    private ConcurrentMap<String, Stack<Stack<BlockRemanence>>> undoQueue = new MapMaker().makeMap();
    private static long pluginStarted;
    private ExtendedConfiguration pluginConfig;

    private ACHelper() {
        int i;
        this.materialsColors = new HashMap();
        this.materialsColors.put(Material.WOOL, new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "LimeGreen", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"});
        this.materialsColors.put(Material.INK_SACK, new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "LimeGreen", "Yellow", "LightBlue", "Magenta", "Orange", "White"});
        this.materialsColors.put(Material.LOG, new String[]{"Oak", "Pine", "Birch"});
        this.materialsColors.put(Material.STEP, new String[]{"Stone", "Sandstone", "Wooden", "Cobblestone"});
        this.materialsColors.put(Material.DOUBLE_STEP, this.materialsColors.get(Material.STEP));
        this.listOfPossibleRepair = new LinkedList<Integer>();
        for (i = 256; i <= 259; ++i) {
            this.listOfPossibleRepair.add(i);
        }
        for (i = 267; i <= 279; ++i) {
            this.listOfPossibleRepair.add(i);
        }
        for (i = 283; i <= 286; ++i) {
            this.listOfPossibleRepair.add(i);
        }
        for (i = 290; i <= 294; ++i) {
            this.listOfPossibleRepair.add(i);
        }
        for (i = 298; i <= 317; ++i) {
            this.listOfPossibleRepair.add(i);
        }
        this.listOfPossibleRepair.add(359);
    }

    public static ACHelper getInstance() {
        if (instance == null) {
            instance = new ACHelper();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    public static Long[] getElapsedTime() {
        return Utils.getElapsedTime(pluginStarted);
    }

    public void addInUndoQueue(String player, Stack<BlockRemanence> blocks) {
        if (this.undoQueue.containsKey(player)) {
            ((Stack)this.undoQueue.get(player)).push(blocks);
        } else {
            Stack<Stack<BlockRemanence>> blockQueue = new Stack<Stack<BlockRemanence>>();
            blockQueue.push(blocks);
            this.undoQueue.put(player, blockQueue);
        }
    }

    public int undoLastModification(String player) throws EmptyStackException {
        if (!this.undoQueue.containsKey(player)) {
            throw new EmptyStackException();
        }
        Stack blockQueue = (Stack)this.undoQueue.get(player);
        if (blockQueue.isEmpty()) {
            throw new EmptyStackException();
        }
        Stack undo = (Stack)blockQueue.pop();
        int i = 0;
        try {
            while (!undo.isEmpty()) {
                ((BlockRemanence)undo.pop()).returnToThePast();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return i;
        }
        return i;
    }

    public ArrayList<ItemStack> getKit(String kit) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        try {
            if (Utils.oddItem != null) {
                result.addAll(Utils.oddItem.getItemGroup(kit, Integer.valueOf(-1)));
                return result;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        List<MaterialContainer> list = this.kits.get(kit);
        if (list != null) {
            for (MaterialContainer mc : list) {
                result.add(mc.getItemStack());
            }
        }
        return result;
    }

    public String getKitList() {
        String kitList = "";
        HashSet<String> list = new HashSet<String>();
        try {
            list.addAll(this.kits.keySet());
            if (Utils.oddItem != null) {
                list.addAll(Utils.oddItem.getGroups());
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        for (String kit : list) {
            kitList = kitList + kit + ", ";
        }
        if (!kitList.equals("") && kitList.endsWith(", ")) {
            kitList = kitList.substring(0, kitList.lastIndexOf(","));
        }
        return kitList.trim();
    }

    public synchronized void reload() {
        CommandManager.getInstance().stopAllExecutorThreads();
        this.pluginInstance.getServer().getScheduler().cancelTasks((Plugin)this.pluginInstance);
        this.storedTypeValues.clear();
        this.alias.clear();
        this.blacklist.clear();
        this.undoQueue.clear();
        this.pluginConfig = new ExtendedConfiguration("config.yml", null);
        this.loadInfos();
        for (Player p : InvisibleWorker.getInstance().getAllInvisiblePlayers()) {
            InvisibleWorker.getInstance().reappear(p);
        }
        InvisibleWorker.killInstance();
        AFKWorker.killInstance();
        CommandManager.killInstance();
        System.gc();
        this.init();
        if (this.pluginConfig.getBoolean("autoAfk", true)) {
            for (Player p : this.pluginInstance.getServer().getOnlinePlayers()) {
                AFKWorker.getInstance().updateTimeStamp(p);
            }
        }
    }

    private void init() {
        if (this.pluginConfig.getBoolean("autoAfk", true)) {
            AFKWorker.getInstance().setExpiration(this.pluginConfig.getInt("afkKickInMinutes", 3) + 1);
            AFKWorker.getInstance().setAfkTime(this.pluginConfig.getInt("afkTimeInSecond", 60));
            AFKWorker.getInstance().setKickTime(this.pluginConfig.getInt("afkKickInMinutes", 3));
            this.pluginInstance.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this.pluginInstance, (Runnable)AFKWorker.getInstance().getAfkChecker(), 0L, (long)(this.pluginConfig.getInt("statutCheckInSec", 20) * 20));
            if (this.pluginConfig.getBoolean("autoKickAfkPlayer", false)) {
                this.pluginInstance.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this.pluginInstance, (Runnable)AFKWorker.getInstance().getKickChecker(), 0L, (long)(this.pluginConfig.getInt("statutCheckInSec", 20) * 20));
            }
        }
        InvisibleWorker.getInstance().setMaxRange(this.pluginConfig.getInt("invisibleRangeInBlock", 512));
        InvisibleWorker.getInstance().setTickCheck(this.pluginConfig.getInt("statutCheckInSec", 20));
        LocaleManager.getInstance().setLocaleFile(this.pluginConfig.getString("locale", "en_US") + ".yml");
        LocaleManager.getInstance().setNoMsg(this.pluginConfig.getBoolean("noMessage", false));
        CommandManager.getInstance().setPlugin(this.pluginInstance);
        CommandManager.getInstance().setDisabledCommands(this.pluginConfig.getStringList("disabledCommands", new LinkedList()));
        CommandManager.getInstance().setPrioritizedCommands(this.pluginConfig.getStringList("prioritizedCommands", new LinkedList()));
        AdminCmd.registerCmds();
        CommandManager.getInstance().checkAlias();
        if (this.pluginConfig.getProperty("pluginStarted") != null) {
            pluginStarted = Long.parseLong(this.pluginConfig.getString("pluginStarted"));
            this.pluginConfig.removeProperty("pluginStarted");
            this.pluginConfig.save();
        } else {
            pluginStarted = System.currentTimeMillis();
        }
    }

    public void setPluginInstance(AdminCmd pluginInstance) {
        this.pluginInstance = pluginInstance;
        this.fManager = FilesManager.getInstance();
        this.fManager.setPath(pluginInstance.getDataFolder().getPath());
        this.fManager.getInnerFile("de_DE.yml", "locales");
        this.fManager.getInnerFile("kits.yml");
        this.pluginConfig = new ExtendedConfiguration("config.yml", null);
        this.pluginConfig.addProperty("resetPowerWhenTpAnotherWorld", true);
        this.pluginConfig.addProperty("noMessage", false);
        this.pluginConfig.addProperty("locale", "en_US");
        this.pluginConfig.addProperty("statutCheckInSec", 20);
        this.pluginConfig.addProperty("invisibleRangeInBlock", 320);
        this.pluginConfig.addProperty("autoAfk", true);
        this.pluginConfig.addProperty("afkTimeInSecond", 60);
        this.pluginConfig.addProperty("autoKickAfkPlayer", false);
        this.pluginConfig.addProperty("afkKickInMinutes", 3);
        this.pluginConfig.addProperty("glideWhenFallingInFlyMode", true);
        this.pluginConfig.addProperty("maxHomeByUser", 0);
        this.pluginConfig.addProperty("fakeQuitWhenInvisible", true);
        this.pluginConfig.addProperty("forceOfficialBukkitPerm", false);
        this.pluginConfig.addProperty("MessageOfTheDay", false);
        this.pluginConfig.addProperty("ColoredSign", true);
        this.pluginConfig.addProperty("DefaultFlyPower", Float.valueOf(1.75f));
        this.pluginConfig.addProperty("DefaultFireBallPower", Float.valueOf(1.0f));
        this.pluginConfig.addProperty("DefaultVulcanPower", Float.valueOf(4.0f));
        this.pluginConfig.addProperty("glinding.multiplicator", Float.valueOf(0.1f));
        this.pluginConfig.addProperty("glinding.YvelocityCheckToGlide", Float.valueOf(-0.2f));
        this.pluginConfig.addProperty("glinding.newYvelocity", Float.valueOf(-0.5f));
        this.pluginConfig.addProperty("prioritizedCommands", Arrays.asList("reload"));
        this.pluginConfig.addProperty("disabledCommands", new LinkedList());
        this.pluginConfig.addProperty("firstConnectionToSpawnPoint", false);
        this.pluginConfig.addProperty("mutedPlayerCantPm", false);
        this.pluginConfig.addProperty("maxRangeForTpAtSee", 400);
        this.pluginConfig.addProperty("tpRequestTimeOutInMinutes", 5);
        this.pluginConfig.addProperty("verboseLog", true);
        this.pluginConfig.save();
        this.init();
    }

    public Object getConfValue(String path) {
        return this.pluginConfig.getProperty(path);
    }

    public Float getFloat(String path) {
        return Float.valueOf(Float.parseFloat(this.pluginConfig.getString(path)));
    }

    public void saveElapsedTime() {
        this.pluginConfig.load();
        this.pluginConfig.setProperty("pluginStarted", pluginStarted);
        this.pluginConfig.save();
    }

    public AdminCmd getPluginInstance() {
        return this.pluginInstance;
    }

    public boolean setBlackListedItem(CommandSender sender, String name) {
        MaterialContainer m = this.checkMaterial(sender, name);
        if (!m.isNull()) {
            Configuration config = this.fManager.getYml("blacklist");
            ArrayList<Integer> list = config.getIntList("BlackListed", null);
            if (list == null) {
                list = new ArrayList<Integer>();
            }
            list.add(m.getMaterial().getId());
            config.setProperty("BlackListed", list);
            config.save();
            if (this.blacklist == null) {
                this.blacklist = new ArrayList<Integer>();
            }
            this.blacklist.add(m.getMaterial().getId());
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", m.getMaterial().toString());
            Utils.sI18n(sender, "addBlacklist", replace);
            return true;
        }
        return false;
    }

    public Set<String> getWarpList() {
        return this.warpList;
    }

    private void addLocationInMemory(String type, String name, Location loc) {
        if (this.locations.containsKey(type)) {
            ((ConcurrentMap)this.locations.get(type)).put(name, loc);
        } else {
            ConcurrentMap tmp = new MapMaker().softValues().expiration(15L, TimeUnit.MINUTES).makeMap();
            tmp.put(name, loc);
            this.locations.put(type, tmp);
        }
    }

    private Location getLocationFromMemory(String type, String name) {
        Location loc = null;
        if (this.locations.containsKey(type)) {
            loc = (Location)((ConcurrentMap)this.locations.get(type)).get(name);
        }
        return loc;
    }

    private void removeLocationFromMemory(String type, String name) {
        if (this.locations.containsKey(type)) {
            ((ConcurrentMap)this.locations.get(type)).remove(name);
            if (((ConcurrentMap)this.locations.get(type)).isEmpty()) {
                this.locations.remove(type);
            }
        }
    }

    public void removeLocation(String type, String nameMemory, String property, String filename) {
        this.removeLocationFromMemory(type, nameMemory);
        this.fManager.removeLocationFromFile(property, filename, type);
    }

    public void removeLocation(String type, String name, String filename) {
        this.removeLocation(type, name, name, filename);
    }

    public void addLocation(String type, String nameMemory, String property, String filename, Location loc) {
        this.addLocationInMemory(type, nameMemory, loc);
        this.fManager.writeLocationFile(loc, property, filename, type);
    }

    public void addLocation(String type, String name, String filename, Location loc) {
        this.addLocation(type, name, name, filename, loc);
    }

    public Location getLocation(String type, String nameMemory, String property, String filename) {
        Location loc = null;
        loc = this.getLocationFromMemory(type, nameMemory);
        if (loc == null && (loc = this.fManager.getLocationFile(property, filename, type)) != null) {
            this.addLocationInMemory(type, nameMemory, loc);
        }
        return loc;
    }

    public Location getLocation(String type, String name, String filename) {
        return this.getLocation(type, name, name, filename);
    }

    public void setSpawn(CommandSender sender) {
        if (Utils.isPlayer(sender)) {
            Location loc = ((Player)sender).getLocation();
            ((Player)sender).getWorld().setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            this.addLocation("spawn", loc.getWorld().getName(), "spawnLocations", loc);
            Utils.sI18n(sender, "setSpawn");
        }
    }

    public void spawn(CommandSender sender) {
        if (Utils.isPlayer(sender)) {
            Player player = (Player)sender;
            Location loc = null;
            String worldName = player.getWorld().getName();
            loc = this.getLocation("spawn", worldName, "spawnLocations");
            if (loc == null) {
                loc = player.getWorld().getSpawnLocation();
            }
            player.teleport(loc);
            Utils.sI18n(sender, "spawn");
        }
    }

    public boolean removeBlackListedItem(CommandSender sender, String name) {
        MaterialContainer m = this.checkMaterial(sender, name);
        if (!m.isNull()) {
            Configuration config = this.fManager.getYml("blacklist");
            List list = config.getIntList("BlackListed", new ArrayList());
            if (!list.isEmpty() && list.contains(m.getMaterial().getId())) {
                list.remove((Object)m.getMaterial().getId());
                config.setProperty("BlackListed", (Object)list);
                config.save();
            }
            if (this.blacklist != null && !this.blacklist.isEmpty() && this.blacklist.contains(m.getMaterial().getId())) {
                this.blacklist.remove((Object)m.getMaterial().getId());
            }
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("getMaterial()", m.getMaterial().toString());
            Utils.sI18n(sender, "rmBlacklist", replace);
            return true;
        }
        return false;
    }

    private List<Integer> getBlackListedItems() {
        return this.fManager.getYml("blacklist").getIntList("BlackListed", new ArrayList());
    }

    public MaterialContainer checkMaterial(CommandSender sender, String mat) {
        MaterialContainer m = Utils.checkMaterial(mat);
        if (m.isNull()) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", mat);
            Utils.sI18n(sender, "unknownMat", replace);
        }
        return m;
    }

    public MaterialContainer getAlias(String name) {
        return (MaterialContainer)this.alias.get(name);
    }

    private short getColor(String name, Material mat) {
        int value = -1;
        try {
            value = Short.parseShort(name);
        }
        catch (Exception e) {
            for (int i = 0; i < this.materialsColors.get(mat).length; i = (int)((short)(i + 1))) {
                if (!this.materialsColors.get(mat)[i].equalsIgnoreCase(name)) continue;
                value = i;
                break;
            }
        }
        if (value < 0 || value >= this.materialsColors.get(mat).length) {
            return -1;
        }
        return (short)value;
    }

    private String printColors(Material mat) {
        String output = "";
        for (int i = 0; i < this.materialsColors.get(mat).length; ++i) {
            output = output + this.materialsColors.get(mat)[i] + ", ";
        }
        return output;
    }

    public void addVulcain(String playerName, float power) {
        this.addValue(Type.VULCAN, playerName, (Object)Float.valueOf(power));
    }

    public void removeVulcan(String playerName) {
        this.removeValue(Type.VULCAN, playerName);
    }

    public void addValue(Type powerName, String user, Object power) {
        if (this.storedTypeValues.containsKey((Object)powerName)) {
            this.storedTypeValues.get((Object)powerName).put(user, power);
        } else {
            ConcurrentMap tmp = new MapMaker().makeMap();
            tmp.put(user, power);
            this.storedTypeValues.put(powerName, tmp);
        }
    }

    public void addValue(Type powerName, Player user, Object power) {
        this.addValue(powerName, user.getName(), power);
    }

    public void addValue(Type powerName, Player user) {
        this.addValue(powerName, user.getName(), (Object)0);
    }

    public void addValue(Type powerName, String user) {
        this.addValue(powerName, user, (Object)0);
    }

    public void removeValue(Type powerName, String user) {
        if (this.storedTypeValues.containsKey((Object)powerName)) {
            this.storedTypeValues.get((Object)powerName).remove(user);
        }
    }

    public void removeValue(Type powerName, Player user) {
        this.removeValue(powerName, user.getName());
    }

    public boolean isValueSet(Type powerName, String user) {
        return this.storedTypeValues.containsKey((Object)powerName) && this.storedTypeValues.get((Object)powerName).containsKey(user);
    }

    public Object getValue(Type powerName, String user) {
        if (user != null && this.isValueSet(powerName, user)) {
            return this.storedTypeValues.get((Object)powerName).get(user);
        }
        return null;
    }

    public Object getValue(Type powerName, Player user) {
        return this.getValue(powerName, user.getName());
    }

    public List<Player> getAllPowerUserOf(Type power) {
        ArrayList<Player> players = new ArrayList<Player>();
        if (this.storedTypeValues.containsKey((Object)power)) {
            for (String player : this.storedTypeValues.get((Object)power).keySet()) {
                players.add(this.pluginInstance.getServer().getPlayer(player));
            }
        }
        return players;
    }

    public boolean removeKeyFromValues(String player) {
        boolean found = false;
        for (Type type : this.storedTypeValues.keySet()) {
            if (!type.getCategory().equals((Object)Type.Category.PLAYER) || this.storedTypeValues.get((Object)type).remove(player) == null) continue;
            found = true;
        }
        return found;
    }

    public boolean isValueSet(Type powerName, Player user) {
        return this.isValueSet(powerName, user.getName());
    }

    public void addThor(String playerName) {
        this.addValue(Type.THOR, playerName);
    }

    public void removeThor(String playerName) {
        this.removeValue(Type.THOR, playerName);
    }

    public boolean hasThorPowers(String player) {
        return this.isValueSet(Type.THOR, player);
    }

    public boolean hasGodPowers(String player) {
        return this.isValueSet(Type.GOD, player);
    }

    public Float getVulcainExplosionPower(String player) {
        return (Float)this.getValue(Type.VULCAN, player);
    }

    public boolean alias(CommandSender sender, String[] args) {
        MaterialContainer m = this.checkMaterial(sender, args[1]);
        if (m.isNull()) {
            return true;
        }
        String alias = args[0];
        this.alias.put(alias, m);
        this.fManager.addAlias(alias, m);
        sender.sendMessage(ChatColor.BLUE + "You can now use " + ChatColor.GOLD + alias + ChatColor.BLUE + " for the item " + ChatColor.GOLD + m.display());
        return true;
    }

    public boolean rmAlias(CommandSender sender, String alias) {
        this.fManager.removeAlias(alias);
        this.alias.remove(alias);
        sender.sendMessage(ChatColor.GOLD + alias + ChatColor.RED + " removed");
        return true;
    }

    public boolean reparable(int id) {
        return this.listOfPossibleRepair.contains(id);
    }

    public boolean itemColor(CommandSender sender, String color) {
        if (Utils.isPlayer(sender)) {
            if (color.equalsIgnoreCase("help")) {
                sender.sendMessage(ChatColor.RED + "Wool: " + ChatColor.WHITE + this.printColors(Material.WOOL));
                sender.sendMessage(ChatColor.RED + "Dyes: " + ChatColor.WHITE + this.printColors(Material.INK_SACK));
                sender.sendMessage(ChatColor.RED + "Logs: " + ChatColor.WHITE + this.printColors(Material.LOG));
                sender.sendMessage(ChatColor.RED + "Slab: " + ChatColor.WHITE + this.printColors(Material.STEP));
                return true;
            }
            short value = -1;
            Material m = ((Player)sender).getItemInHand().getType();
            if (!this.materialsColors.containsKey(m)) {
                sender.sendMessage(ChatColor.RED + "You must hold a colorable material!");
                return true;
            }
            value = this.getColor(color, m);
            if (value < 0) {
                sender.sendMessage(ChatColor.RED + "Color " + ChatColor.WHITE + color + ChatColor.RED + " is not usable for what you're holding!");
                return true;
            }
            ((Player)sender).getItemInHand().setDurability(value);
        }
        return true;
    }

    public boolean inBlackList(CommandSender sender, MaterialContainer mat) {
        if (!PermissionManager.hasPerm(sender, "admincmd.item.noblacklist", false) && this.blacklist.contains(mat.getMaterial().getId())) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", mat.display());
            Utils.sI18n(sender, "inBlacklist", replace);
            return true;
        }
        return false;
    }

    public boolean inBlackList(CommandSender sender, ItemStack mat) {
        if (!PermissionManager.hasPerm(sender, "admincmd.item.noblacklist", false) && this.blacklist.contains(mat.getTypeId())) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("material", mat.getType().toString());
            Utils.sI18n(sender, "inBlacklist", replace);
            return true;
        }
        return false;
    }

    public void addValueWithFile(Type power, String user, Object value) {
        this.addValue(power, user, value);
        Configuration ban = this.fManager.getYml(power.toString());
        ban.setProperty((Object)((Object)power) + "." + user, value);
        ban.save();
    }

    public void removeValueWithFile(Type power, String user) {
        this.removeValue(power, user);
        Configuration ban = this.fManager.getYml(power.toString());
        ban.removeProperty((Object)((Object)power) + "." + user);
        ban.save();
    }

    public Set<String> getHomeList(String player) {
        if (this.homeList.containsKey(player)) {
            return (Set)this.homeList.get(player);
        }
        List<String> tmp = this.fManager.getYmlKeyFromFile(player, "home");
        if (tmp != null) {
            this.homeList.put(player, new HashSet<String>(tmp));
        } else {
            this.homeList.put(player, new HashSet());
        }
        return (Set)this.homeList.get(player);
    }

    public synchronized void loadInfos() {
        this.blacklist = this.getBlackListedItems();
        this.alias.putAll(this.fManager.getAlias());
        List<String> tmp = this.fManager.getYmlKeyFromFile("warpPoints", "warp");
        if (tmp != null) {
            this.warpList.addAll(tmp);
        }
        Map<String, Object> map = this.fManager.loadMap(Type.BANNED, null, Type.BANNED.toString());
        for (String key : map.keySet()) {
            this.addValue(Type.BANNED, key, map.get(key));
        }
        Map<String, Object> map2 = this.fManager.loadMap(Type.MUTED, null, Type.MUTED.toString());
        for (String key : map2.keySet()) {
            this.addValue(Type.MUTED, key, map2.get(key));
        }
        this.kits.putAll(this.fManager.loadKits());
        if (this.pluginConfig.getBoolean("verboseLog", true)) {
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.blacklist.size() + " blacklisted items loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.alias.size() + " alias loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + map.size() + " Banned players loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + map2.size() + " Muted players loaded.");
            Logger.getLogger("Minecraft").info("[AdminCmd] " + this.kits.size() + " kits loaded.");
        }
    }

    public int getLimit(Player player, String type) {
        Integer limit = null;
        String toParse = PermissionManager.getPermissionLimit(player, "maxHomeByUser");
        Integer n = limit = toParse != null && !toParse.isEmpty() ? Integer.valueOf(Integer.parseInt(toParse)) : null;
        if (limit == null || limit == -1) {
            limit = this.pluginConfig.getInt(type, 0);
        }
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        return limit;
    }
}

