/*
 * Decompiled with CFR 0.152.
 */
package com.bukkit.gemo.FalseBook.Block.Areas;

import com.bukkit.gemo.FalseBook.Block.Areas.AreaBlock;
import com.bukkit.gemo.FalseBook.Block.Areas.AreaBlockType;
import com.bukkit.gemo.FalseBook.Block.Areas.AreaChest;
import com.bukkit.gemo.FalseBook.Block.Areas.AreaLocation;
import com.bukkit.gemo.FalseBook.Block.Areas.AreaSign;
import com.bukkit.gemo.FalseBook.Block.Areas.SchedulerArea;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockCore;
import com.gemo.utils.BlockUtils;
import java.io.Serializable;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Area
implements Serializable {
    private static final long serialVersionUID = -1879686687354057051L;
    private ArrayList<AreaBlock> bList;
    private String worldName;
    private AreaLocation pos1;
    private AreaLocation pos2;
    private boolean show = true;
    private boolean autoSave = true;
    private boolean protect = false;
    private String AreaName = "";
    private ArrayList<AreaBlockType> AllowedBlocks;

    public Area(World w, String Name, Location selP1, Location selP2) {
        this.AreaName = Name;
        this.bList = new ArrayList();
        if (selP1.getX() > selP2.getX()) {
            double xVar = selP2.getX();
            selP2.setX(selP1.getX());
            selP1.setX(xVar);
        }
        if (selP1.getY() > selP2.getY()) {
            double yVar = selP2.getY();
            selP2.setY(selP1.getY());
            selP1.setY(yVar);
        }
        if (selP1.getZ() > selP2.getZ()) {
            double zVar = selP2.getZ();
            selP2.setZ(selP1.getZ());
            selP1.setZ(zVar);
        }
        this.worldName = w.getName();
        this.pos1 = new AreaLocation(selP1);
        this.pos2 = new AreaLocation(selP2);
        this.updateArea(w);
    }

    public void updateArea(World world) {
        this.bList.clear();
        int x = this.pos1.getBlockX();
        while (x <= this.pos2.getBlockX()) {
            int z = this.pos1.getBlockZ();
            while (z <= this.pos2.getBlockZ()) {
                int y = this.pos1.getBlockY();
                while (y <= this.pos2.getBlockY()) {
                    AreaBlock newBlock = new AreaBlock(x, y, z, world.getBlockAt(x, y, z).getTypeId(), world.getBlockAt(x, y, z).getData());
                    this.bList.add(newBlock);
                    if (BlockUtils.isComplexBlock((Block)world.getBlockAt(x, y, z)) || world.getBlockAt(x, y, z).getType().equals((Object)Material.CHEST)) {
                        if (world.getBlockAt(x, y, z).getType().equals((Object)Material.WALL_SIGN) || world.getBlockAt(x, y, z).getType().equals((Object)Material.SIGN_POST)) {
                            Sign sign = (Sign)world.getBlockAt(x, y, z).getState();
                            newBlock.setInheritedData(new AreaSign(sign.getLines()));
                        } else if (world.getBlockAt(x, y, z).getType().equals((Object)Material.CHEST)) {
                            Chest chest = (Chest)world.getBlockAt(x, y, z).getState();
                            newBlock.setInheritedData(new AreaChest(chest.getInventory()));
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    public boolean isBlockInArea(Block block) {
        return block.getX() >= this.pos1.getBlockX() && block.getX() <= this.pos2.getBlockX() && block.getY() >= this.pos1.getBlockY() && block.getY() <= this.pos2.getBlockY() && block.getZ() >= this.pos1.getBlockZ() && block.getZ() <= this.pos2.getBlockZ() && block.getWorld().getName().equalsIgnoreCase(this.pos1.getWorldName());
    }

    public void toggle(FalseBookBlockCore plugin) {
        if (this.show) {
            this.toggle(false, plugin);
        } else {
            this.toggle(true, plugin);
        }
    }

    public void initArea() {
        if (this.AllowedBlocks == null) {
            this.AllowedBlocks = new ArrayList();
        }
    }

    public boolean isInAllowed(int ID, byte Data) {
        int i = 0;
        while (i < this.AllowedBlocks.size()) {
            if (this.AllowedBlocks.get(i).getTypeID() == ID && this.AllowedBlocks.get(i).getData() == Data) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getInAllowed(int ID, byte Data) {
        int i = 0;
        while (i < this.AllowedBlocks.size()) {
            if (this.AllowedBlocks.get(i).getTypeID() == ID && this.AllowedBlocks.get(i).getData() == Data) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isInAllowed(AreaBlockType thisBlock) {
        return this.isInAllowed(thisBlock.getTypeID(), thisBlock.getData());
    }

    public void toggle(boolean on, FalseBookBlockCore plugin) {
        int i;
        if (this.show == on || this.isProtect()) {
            return;
        }
        this.initArea();
        this.show = on;
        ArrayList<AreaBlock> QueuedBlocks = new ArrayList<AreaBlock>();
        World world = plugin.getServer().getWorld(this.worldName);
        if (on) {
            i = 0;
            while (i < this.bList.size()) {
                if (this.bList.get(i).getTypeID() != Material.CHEST.getId() && !BlockUtils.isComplexBlock((int)this.bList.get(i).getTypeID())) {
                    world.getBlockAt(this.bList.get(i).getxPos(), this.bList.get(i).getyPos(), this.bList.get(i).getzPos()).setTypeIdAndData(this.bList.get(i).getTypeID(), this.bList.get(i).getData(), true);
                } else {
                    QueuedBlocks.add(this.bList.get(i));
                }
                ++i;
            }
            if (this.autoSave) {
                this.bList.clear();
            }
        } else if (!on) {
            if (this.isAutoSave()) {
                this.updateArea(world);
            }
            int x = this.pos1.getBlockX();
            while (x <= this.pos2.getBlockX()) {
                int z = this.pos1.getBlockZ();
                while (z <= this.pos2.getBlockZ()) {
                    int y = this.pos1.getBlockY();
                    while (y <= this.pos2.getBlockY()) {
                        AreaBlockType thisBlock = new AreaBlockType(world.getBlockAt(x, y, z).getTypeId(), world.getBlockAt(x, y, z).getData());
                        if (this.isInAllowed(thisBlock) || this.AllowedBlocks.size() == 0) {
                            if (BlockUtils.isComplexBlock((int)world.getBlockAt(x, y, z).getTypeId()) && world.getBlockAt(x, y, z).getTypeId() != Material.CHEST.getId()) {
                                world.getBlockAt(x, y, z).setTypeIdAndData(Material.AIR.getId(), (byte)0, true);
                            } else {
                                QueuedBlocks.add(new AreaBlock(x, y, z, world.getBlockAt(x, y, z).getTypeId(), world.getBlockAt(x, y, z).getData()));
                            }
                        }
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
        }
        if (QueuedBlocks.size() > 0) {
            if (on) {
                i = 0;
                while (i < QueuedBlocks.size()) {
                    AreaBlock aBlock = (AreaBlock)QueuedBlocks.get(i);
                    world.getBlockAt(aBlock.getxPos(), aBlock.getyPos(), aBlock.getzPos()).setTypeIdAndData(aBlock.getTypeID(), aBlock.getData(), true);
                    if (aBlock.getTypeID() == Material.CHEST.getId()) {
                        Chest chest = (Chest)world.getBlockAt(aBlock.getxPos(), aBlock.getyPos(), aBlock.getzPos()).getState();
                        AreaChest aChest = (AreaChest)((AreaBlock)QueuedBlocks.get(i)).getInheritedData();
                        ItemStack[] items = new ItemStack[aChest.getItemList().size()];
                        chest.getInventory().clear();
                        int j = 0;
                        while (j < aChest.getItemList().size()) {
                            items[j] = new ItemStack(aChest.getItemList().get(j).getTypeID(), aChest.getItemList().get(j).getCount());
                            items[j].setAmount(aChest.getItemList().get(j).getCount());
                            ++j;
                        }
                        chest.getInventory().setContents(items);
                    }
                    ++i;
                }
                FalseBookBlockCore.server.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new SchedulerArea(world, this.bList));
            } else if (!on) {
                i = 0;
                while (i < QueuedBlocks.size()) {
                    AreaBlock aBlock = (AreaBlock)QueuedBlocks.get(i);
                    if (world.getBlockAt(aBlock.getxPos(), aBlock.getyPos(), aBlock.getzPos()).getType().equals((Object)Material.CHEST)) {
                        Chest chest = (Chest)world.getBlockAt(aBlock.getxPos(), aBlock.getyPos(), aBlock.getzPos()).getState();
                        chest.getInventory().clear();
                    }
                    world.getBlockAt(aBlock.getxPos(), aBlock.getyPos(), aBlock.getzPos()).setTypeIdAndData(Material.AIR.getId(), (byte)0, true);
                    ++i;
                }
            }
        }
        this.show = on;
    }

    public String saveArea() {
        String res = "";
        res = String.valueOf(res) + this.worldName + ":";
        res = String.valueOf(res) + this.pos1.getBlockX() + "," + this.pos1.getBlockY() + "," + this.pos1.getBlockZ() + ":";
        res = String.valueOf(res) + this.pos2.getBlockX() + "," + this.pos2.getBlockY() + "," + this.pos2.getBlockZ() + ":";
        res = String.valueOf(res) + this.AreaName + ":";
        res = String.valueOf(res) + this.isAutoSave() + ":";
        res = String.valueOf(res) + this.isProtect() + ";";
        return res;
    }

    public String getAreaName() {
        return this.AreaName;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setProtect(boolean protect) {
        this.protect = protect;
    }

    public boolean isProtect() {
        return this.protect;
    }

    public ArrayList<AreaBlock> getbList() {
        return this.bList;
    }

    public void setbList(ArrayList<AreaBlock> bList) {
        this.bList = bList;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setAllowedBlocks(ArrayList<AreaBlockType> allowedBlocks) {
        this.AllowedBlocks = allowedBlocks;
    }

    public ArrayList<AreaBlockType> getAllowedBlocks() {
        return this.AllowedBlocks;
    }
}

