/*
 * Decompiled with CFR 0.152.
 */
package com.bukkit.gemo.FalseBook.Block;

import com.bukkit.gemo.FalseBook.Block.BridgeArea;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockBlockListener;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockCore;
import com.gemo.utils.SignUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class Bridge {
    public static boolean isBlockTypeAllowed(int ID, String worldName) {
        ArrayList<Integer> list = FalseBookBlockCore.getAllowedBridgeBlocks(worldName);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == ID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int toggle(Sign signBlock) {
        if (signBlock.getTypeId() != Material.WALL_SIGN.getId() && signBlock.getTypeId() != Material.SIGN_POST.getId()) {
            return -10;
        }
        int signDir = SignUtils.getDirection((Sign)signBlock);
        if (signDir == -1) {
            return -9;
        }
        int bridgeLeft = 1;
        int bridgeRight = 1;
        try {
            bridgeLeft = Integer.valueOf(signBlock.getLine(2));
        }
        catch (Exception e) {
            bridgeLeft = 1;
        }
        try {
            bridgeRight = Integer.valueOf(signBlock.getLine(3));
        }
        catch (Exception e) {
            bridgeRight = 1;
        }
        Sign opSign = Bridge.getOppositeSign(signBlock, signDir);
        if (opSign == null) {
            return -8;
        }
        int bridge2ndLeft = 1;
        int bridge2ndRight = 1;
        try {
            bridge2ndLeft = Integer.valueOf(opSign.getLine(2));
        }
        catch (Exception e) {
            bridge2ndLeft = 1;
        }
        try {
            bridge2ndRight = Integer.valueOf(opSign.getLine(3));
        }
        catch (Exception e) {
            bridge2ndRight = 1;
        }
        if (bridgeLeft != bridge2ndRight || bridgeRight != bridge2ndLeft) {
            return -7;
        }
        if (signDir == 2 || signDir == 4) {
            int tmp = bridgeLeft;
            bridgeLeft = bridgeRight;
            bridgeRight = tmp;
        }
        int result = -10;
        result = Bridge.toggle(signBlock, opSign, signBlock.getBlock().getRelative(0, 1, 0), signDir, bridgeLeft, bridgeRight, 1);
        if (result != 8) {
            result = Bridge.toggle(signBlock, opSign, signBlock.getBlock().getRelative(0, -1, 0), signDir, bridgeLeft, bridgeRight, -1);
        }
        return result;
    }

    public static int toggle(Sign signBlock, Sign opSign, Block originBlock, int signDir, int bridgeLeft, int bridgeRight, int yOffset) {
        boolean toggleOn;
        if (!Bridge.isBlockTypeAllowed(originBlock.getTypeId(), originBlock.getWorld().getName())) {
            originBlock = null;
            return 0;
        }
        ArrayList<Block> BaseBlocks = Bridge.getBase(signBlock, opSign, signDir, bridgeLeft, bridgeRight, yOffset);
        if (!Bridge.verifyBaseBlocks(BaseBlocks, originBlock, true)) {
            BaseBlocks.clear();
            BaseBlocks = null;
            return 1;
        }
        ArrayList<Block> newArea = Bridge.getArea(signBlock, opSign, signDir, bridgeLeft, bridgeRight, yOffset);
        if (newArea.size() == 0) {
            return 2;
        }
        boolean bl = toggleOn = newArea.get(0).getTypeId() != originBlock.getTypeId();
        if (toggleOn) {
            if (!Bridge.verifyBaseBlocks(newArea, 0, (byte)0, false)) {
                BaseBlocks.clear();
                BaseBlocks = null;
                return 1;
            }
        } else if (!Bridge.verifyBaseBlocks(newArea, originBlock, false)) {
            BaseBlocks.clear();
            BaseBlocks = null;
            return 1;
        }
        int i = 0;
        while (i < newArea.size()) {
            if (toggleOn) {
                newArea.get(i).setTypeIdAndData(originBlock.getTypeId(), originBlock.getData(), true);
            } else {
                newArea.get(i).setTypeIdAndData(0, (byte)0, true);
            }
            ++i;
        }
        BridgeArea now = new BridgeArea(signBlock, opSign);
        if (originBlock.getY() > signBlock.getY()) {
            now.setUp(true);
        } else {
            now.setUp(false);
        }
        if (!toggleOn) {
            if (FalseBookBlockBlockListener.isInBridgeList(now) != -1) {
                FalseBookBlockBlockListener.getBridgeAreas().remove(FalseBookBlockBlockListener.isInBridgeList(now));
            }
        } else {
            now.setON(true);
            if (FalseBookBlockBlockListener.isInBridgeList(now) == -1) {
                FalseBookBlockBlockListener.getBridgeAreas().add(now);
            }
            now.addBlock(signBlock.getBlock());
            now.addBlock(opSign.getBlock());
            if (originBlock.getY() > signBlock.getY()) {
                now.addBlock(signBlock.getBlock().getRelative(0, -1, 0));
                now.addBlock(opSign.getBlock().getRelative(0, -1, 0));
            }
            int i2 = 0;
            while (i2 < BaseBlocks.size()) {
                now.addBlock(BaseBlocks.get(i2));
                ++i2;
            }
            i2 = 0;
            while (i2 < newArea.size()) {
                now.addBlock(newArea.get(i2));
                ++i2;
            }
        }
        originBlock = null;
        newArea.clear();
        newArea = null;
        BaseBlocks.clear();
        BaseBlocks = null;
        return 8;
    }

    public static ArrayList<Block> getArea(Sign firstSign, Sign secondSign, int signDir, int widthLeft, int widthRight, int yDir) {
        ArrayList<Block> newArea = new ArrayList<Block>();
        Block originBlock = firstSign.getBlock();
        int flag = 1;
        if (signDir == 1 || signDir == 3) {
            if (signDir == 1) {
                flag = -1;
            }
            int bridgeLength = Math.abs(firstSign.getBlock().getZ() - secondSign.getBlock().getZ()) - 1;
            int i = 1;
            while (i <= bridgeLength) {
                newArea.add(originBlock.getRelative(0, yDir, i * flag));
                int left = 1;
                while (left <= widthLeft) {
                    newArea.add(originBlock.getRelative(left * flag, yDir, i * flag));
                    ++left;
                }
                int right = 1;
                while (right <= widthRight) {
                    newArea.add(originBlock.getRelative(right * flag * -1, yDir, i * flag));
                    ++right;
                }
                ++i;
            }
        } else {
            if (signDir == 2) {
                flag = -1;
            }
            int bridgeLength = Math.abs(firstSign.getBlock().getX() - secondSign.getBlock().getX()) - 1;
            int i = 1;
            while (i <= bridgeLength) {
                newArea.add(originBlock.getRelative(i * flag, yDir, 0));
                int left = 1;
                while (left <= widthLeft) {
                    newArea.add(originBlock.getRelative(i * flag, yDir, left * flag));
                    ++left;
                }
                int right = 1;
                while (right <= widthRight) {
                    newArea.add(originBlock.getRelative(i * flag, yDir, right * flag * -1));
                    ++right;
                }
                ++i;
            }
        }
        return newArea;
    }

    public static ArrayList<Block> getBase(Sign firstSign, Sign secondSign, int signDir, int widthLeft, int widthRight, int yDir) {
        ArrayList<Block> newArea = new ArrayList<Block>();
        Block originBlock = firstSign.getBlock();
        Block originBlock2nd = secondSign.getBlock();
        int flag = 1;
        if (signDir == 1 || signDir == 3) {
            if (signDir == 1) {
                flag = -1;
            }
            newArea.add(originBlock.getRelative(0, yDir, 0));
            newArea.add(originBlock2nd.getRelative(0, yDir, 0));
            int left = 1;
            while (left <= widthLeft) {
                newArea.add(originBlock.getRelative(left * flag, yDir, 0));
                newArea.add(originBlock2nd.getRelative(left * flag, yDir, 0));
                ++left;
            }
            int right = 1;
            while (right <= widthRight) {
                newArea.add(originBlock.getRelative(right * flag * -1, yDir, 0));
                newArea.add(originBlock2nd.getRelative(right * flag * -1, yDir, 0));
                ++right;
            }
        } else {
            if (signDir == 2) {
                flag = -1;
            }
            newArea.add(originBlock.getRelative(0, yDir, 0));
            newArea.add(originBlock2nd.getRelative(0, yDir, 0));
            int left = 1;
            while (left <= widthLeft) {
                newArea.add(originBlock.getRelative(0, yDir, left * flag));
                newArea.add(originBlock2nd.getRelative(0, yDir, left * flag));
                ++left;
            }
            int right = 1;
            while (right <= widthRight) {
                newArea.add(originBlock.getRelative(0, yDir, right * flag * -1));
                newArea.add(originBlock2nd.getRelative(0, yDir, right * flag * -1));
                ++right;
            }
        }
        return newArea;
    }

    public static boolean verifyBaseBlocks(ArrayList<Block> BaseBlocks, Block origin, boolean base) {
        return Bridge.verifyBaseBlocks(BaseBlocks, origin.getTypeId(), origin.getData(), base);
    }

    public static boolean verifyBaseBlocks(ArrayList<Block> BaseBlocks, int TypeID, byte Data, boolean base) {
        int i = 0;
        while (i < BaseBlocks.size()) {
            if (BaseBlocks.get(i).getTypeId() != TypeID) {
                if (base) {
                    return false;
                }
                if (!BaseBlocks.get(i).isLiquid()) {
                    return false;
                }
            } else if (BaseBlocks.get(i).getData() != Data) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Sign getOppositeSign(Sign signBlock, int signDir) {
        Block block = signBlock.getBlock();
        int thisID = -1;
        int flag = 1;
        if (signDir == 1 || signDir == 3) {
            if (signDir == 1) {
                flag = -1;
            }
            int i = 2;
            while (i <= FalseBookBlockCore.getMaxBridgeLength(signBlock.getWorld().getName()) + 1) {
                thisID = block.getRelative(0, 0, i * flag).getTypeId();
                if (thisID == Material.WALL_SIGN.getId() || thisID == Material.SIGN_POST.getId()) {
                    Sign opSign = (Sign)block.getRelative(0, 0, i * flag).getState();
                    if ((signDir == 1 && SignUtils.getDirection((Sign)opSign) == 3 || signDir == 3 && SignUtils.getDirection((Sign)opSign) == 1) && (opSign.getLine(1).equalsIgnoreCase("[Bridge]") || opSign.getLine(1).equalsIgnoreCase("[Bridge End]"))) {
                        return opSign;
                    }
                }
                ++i;
            }
        } else {
            if (signDir == 2) {
                flag = -1;
            }
            int i = 2;
            while (i <= FalseBookBlockCore.getMaxBridgeLength(signBlock.getWorld().getName())) {
                thisID = block.getRelative(i * flag, 0, 0).getTypeId();
                if (thisID == Material.WALL_SIGN.getId() || thisID == Material.SIGN_POST.getId()) {
                    Sign opSign = (Sign)block.getRelative(i * flag, 0, 0).getState();
                    if ((signDir == 2 && SignUtils.getDirection((Sign)opSign) == 4 || signDir == 4 && SignUtils.getDirection((Sign)opSign) == 2) && (opSign.getLine(1).equalsIgnoreCase("[Bridge]") || opSign.getLine(1).equalsIgnoreCase("[Bridge End]"))) {
                        return opSign;
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

