/*
 * Decompiled with CFR 0.152.
 */
package com.bukkit.gemo.FalseBook.Block;

import com.bukkit.gemo.FalseBook.Block.Areas.Area;
import com.bukkit.gemo.FalseBook.Block.Areas.AreaBlockType;
import com.bukkit.gemo.FalseBook.Block.BlockWorldSettings;
import com.bukkit.gemo.FalseBook.Block.Bookshelf;
import com.bukkit.gemo.FalseBook.Block.CauldronHandler;
import com.bukkit.gemo.FalseBook.Block.DataLoader_Area;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockBlockListener;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockEntityListener;
import com.bukkit.gemo.FalseBook.Block.FalseBookBlockPlayerListener;
import com.gemo.FalseBook.Core.FalseBookCore;
import com.gemo.utils.FileUtils;
import com.gemo.utils.UtilPermissions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FalseBookBlockCore
extends JavaPlugin {
    private FalseBookCore core;
    private static String pluginName;
    public static Server server;
    private static FalseBookBlockBlockListener blockListener;
    private static FalseBookBlockPlayerListener playerListener;
    private static FalseBookBlockEntityListener entityListener;
    private static HashMap<String, BlockWorldSettings> Settings;

    public static void printInConsole(String str) {
        System.out.println("[FalseBook Block] " + str);
    }

    public void onDisable() {
        if (this.searchCore()) {
            blockListener.saveBridges();
            blockListener.saveDoors();
            blockListener.saveGates();
            System.out.println(String.valueOf(pluginName) + " disabled");
        }
    }

    public boolean importExportAreas() {
        File f = new File("plugins/FalseBook/Areas.db2");
        if (!f.exists()) {
            return false;
        }
        try {
            ObjectInputStream objIn2 = new ObjectInputStream(new BufferedInputStream(new FileInputStream("plugins/FalseBook/Areas.db2")));
            int count = (Integer)objIn2.readObject();
            int i = 0;
            while (i < count) {
                try {
                    Area newArea = (Area)objIn2.readObject();
                    newArea.initArea();
                    FalseBookBlockBlockListener.getAreas().add(newArea);
                }
                catch (Exception e) {
                    FalseBookBlockCore.printInConsole("An error occured while loading an Area...");
                }
                ++i;
            }
            objIn2.close();
            FalseBookBlockCore.printInConsole(String.valueOf(FalseBookBlockBlockListener.getAreas().size()) + " Areas imported.");
            f.delete();
            for (Area area : FalseBookBlockBlockListener.getAreas()) {
                this.saveAreas(area.getAreaName(), true);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            FalseBookBlockCore.printInConsole("Error while reading plugins/FalseBook/Areas.db2");
            return false;
        }
    }

    public void onEnable() {
        if (!this.searchCore()) {
            FalseBookBlockCore.printInConsole(">>>>> FalseBookCore.jar not found! FalseBookBlock.jar is being disabled!");
            return;
        }
        this.loadVersion();
        server = this.getServer();
        this.checkForDefaultSettings();
        this.loadWorldSettings();
        blockListener = new FalseBookBlockBlockListener(this);
        playerListener = new FalseBookBlockPlayerListener(this);
        entityListener = new FalseBookBlockEntityListener(this);
        Bookshelf.loadBooksFromFile();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)playerListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PISTON_EXTEND, (Listener)blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PISTON_RETRACT, (Listener)blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.REDSTONE_CHANGE, (Listener)blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_EXPLODE, (Listener)entityListener, Event.Priority.Highest, (Plugin)this);
        System.out.println(String.valueOf(pluginName) + " enabled");
        DataLoader_Area tmpDL = new DataLoader_Area(this);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)tmpDL);
        CauldronHandler.loadCauldrons("FalseBook/Cauldrons.txt");
    }

    public void checkForDefaultSettings() {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        File f = new File("plugins/FalseBook/FalseBookBlock.properties");
        if (!f.exists()) {
            return;
        }
        f = null;
        int i = 0;
        while (i < server.getWorlds().size()) {
            this.checkForDefaultSettings(((World)server.getWorlds().get(i)).getName());
            ++i;
        }
    }

    public void checkForDefaultSettings(String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        File f = new File("plugins/FalseBook/FalseBookBlock.properties");
        if (!f.exists()) {
            return;
        }
        f = null;
        if (server.getWorld(worldName) == null) {
            return;
        }
        folder = new File("plugins/FalseBook/" + server.getWorld(worldName).getName());
        folder.mkdirs();
        try {
            f = new File("plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookBlock.properties");
            if (!f.exists()) {
                FileUtils.copyFile((String)"plugins/FalseBook/FalseBookBlock.properties", (String)("plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookBlock.properties"));
            }
        }
        catch (Exception e) {
            FalseBookBlockCore.printInConsole("Error while copying 'plugins/FalseBook/FalseBookBlock.properties' to 'plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookBlock.properties'");
        }
    }

    public void loadWorldSettings() {
        if (Settings != null) {
            Settings.clear();
        } else {
            Settings = new HashMap();
        }
        int i = 0;
        while (i < server.getWorlds().size()) {
            this.loadWorldSettings(((World)server.getWorlds().get(i)).getName());
            ++i;
        }
    }

    public void loadWorldSettings(String worldName) {
        if (server.getWorld(worldName) == null) {
            return;
        }
        Settings.put(server.getWorld(worldName).getName(), new BlockWorldSettings("FalseBookBlock.properties", server.getWorld(worldName).getName()));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!this.searchCore()) {
            return true;
        }
        if (sender instanceof Player) {
            String areaName;
            Player player = (Player)sender;
            if (commandLabel.equalsIgnoreCase("fbblock") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.*") && args != null && args.length == 1) {
                if (args[0].equalsIgnoreCase("reloadsettings")) {
                    player.sendMessage(ChatColor.YELLOW + "Reloading Block-Settings...");
                    Settings.clear();
                    this.checkForDefaultSettings();
                    this.loadWorldSettings();
                    player.sendMessage(ChatColor.YELLOW + "Block-Settings reloaded successfully!");
                }
                if (args[0].equalsIgnoreCase("reload")) {
                    player.sendMessage(ChatColor.YELLOW + "Reloading...");
                    FalseBookBlockBlockListener.getAreas().clear();
                    FalseBookBlockBlockListener.getBridgeAreas().clear();
                    FalseBookBlockBlockListener.getDoorAreas().clear();
                    FalseBookBlockBlockListener.getGateAreas().clear();
                    DataLoader_Area loader = new DataLoader_Area(this);
                    loader.run();
                    player.sendMessage(ChatColor.YELLOW + "Reload complete!");
                }
            }
            if (commandLabel.equalsIgnoreCase("farea") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) {
                String[] split = args;
                if (split.length > 0) {
                    boolean f = false;
                    String aName = "";
                    int i = 0;
                    while (i < split.length) {
                        aName = String.valueOf(aName) + split[i];
                        if (i < split.length - 1) {
                            aName = String.valueOf(aName) + " ";
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < FalseBookBlockBlockListener.getAreas().size()) {
                        if (FalseBookBlockBlockListener.getAreas().get(i).getAreaName().equalsIgnoreCase(aName)) {
                            f = true;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < FalseBookBlockBlockListener.getSelection().size()) {
                        if (FalseBookBlockBlockListener.getSelection().get((int)i).player.getName().equalsIgnoreCase(player.getName())) {
                            if (FalseBookBlockBlockListener.getSelection().get((int)i).selP1 != null && FalseBookBlockBlockListener.getSelection().get((int)i).selP2 != null) {
                                Area newArea = new Area(player.getWorld(), aName, FalseBookBlockBlockListener.getSelection().get((int)i).selP1, FalseBookBlockBlockListener.getSelection().get((int)i).selP2);
                                newArea.initArea();
                                FalseBookBlockBlockListener.getAreas().add(newArea);
                                this.saveAreas(aName, true);
                                player.sendMessage(ChatColor.GREEN + "FalseBook-Area saved as: '" + aName + "'");
                                if (f) {
                                    player.sendMessage(ChatColor.GRAY + "WARNING: Area created, but there are multiple areas with that name!");
                                }
                                return true;
                            }
                            player.sendMessage(ChatColor.RED + "Please define an area first! (Rightclick with woodhoe)");
                            break;
                        }
                        ++i;
                    }
                }
            } else if (commandLabel.equalsIgnoreCase("delfarea") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) {
                if (args.length > 0) {
                    String aName = "";
                    int i = 0;
                    while (i < args.length) {
                        aName = String.valueOf(aName) + args[i];
                        if (i < args.length - 1) {
                            aName = String.valueOf(aName) + " ";
                        }
                        ++i;
                    }
                    this.deleteArea(player, aName);
                }
            } else if (commandLabel.equalsIgnoreCase("listfarea") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) {
                this.listAreas(player);
            } else if (commandLabel.equalsIgnoreCase("fareaallow") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) {
                if (args.length >= 2) {
                    areaName = "";
                    int i = 0;
                    while (i < args.length - 1) {
                        if (i > 0) {
                            areaName = String.valueOf(areaName) + " ";
                        }
                        areaName = String.valueOf(areaName) + args[i];
                        ++i;
                    }
                    String[] split = args[args.length - 1].split(":");
                    int typeID = 0;
                    byte typeData = 0;
                    if (split.length == 1) {
                        try {
                            typeID = Integer.valueOf(split[0]);
                        }
                        catch (Exception e) {
                            player.sendMessage(ChatColor.RED + "Wrong syntax! Use '/fareaallow <areaname> <ID>[:<SUB>]'");
                            return false;
                        }
                    }
                    try {
                        typeID = Integer.valueOf(split[0]);
                        typeData = Byte.valueOf(split[1]);
                    }
                    catch (Exception e) {
                        player.sendMessage(ChatColor.RED + "Wrong syntax! Use '/fareaallow <areaname> <ID>[:<SUB>]'");
                        return false;
                    }
                    AreaBlockType thisBlock = new AreaBlockType(typeID, typeData);
                    boolean f = false;
                    int i2 = FalseBookBlockBlockListener.getAreas().size() - 1;
                    while (i2 >= 0) {
                        if (FalseBookBlockBlockListener.getAreas().get(i2).getAreaName().equalsIgnoreCase(areaName)) {
                            if (!FalseBookBlockBlockListener.getAreas().get(i2).isInAllowed(thisBlock)) {
                                FalseBookBlockBlockListener.getAreas().get(i2).getAllowedBlocks().add(thisBlock);
                                player.sendMessage(ChatColor.GREEN + "Added " + typeID + ":" + typeData + " to toggleable Blocks!");
                            } else {
                                FalseBookBlockBlockListener.getAreas().get(i2).getAllowedBlocks().remove(FalseBookBlockBlockListener.getAreas().get(i2).getInAllowed(thisBlock.getTypeID(), thisBlock.getData()));
                                player.sendMessage(ChatColor.GREEN + "Removed " + typeID + ":" + typeData + " from toggleable Blocks!");
                            }
                            this.saveAreas(FalseBookBlockBlockListener.getAreas().get(i2).getAreaName(), true);
                            f = true;
                        }
                        --i2;
                    }
                    if (!f) {
                        player.sendMessage(ChatColor.RED + "Area '" + areaName + "' not found!");
                    }
                }
            } else if (commandLabel.equalsIgnoreCase("fareaListAllow") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area")) {
                if (args.length >= 1) {
                    areaName = "";
                    int i = 0;
                    while (i < args.length - 1) {
                        if (i > 0) {
                            areaName = String.valueOf(areaName) + " ";
                        }
                        areaName = String.valueOf(areaName) + args[i];
                        ++i;
                    }
                    boolean f = false;
                    int i3 = FalseBookBlockBlockListener.getAreas().size() - 1;
                    while (i3 >= 0) {
                        if (FalseBookBlockBlockListener.getAreas().get(i3).getAreaName().equalsIgnoreCase(areaName)) {
                            String txt = "";
                            if (FalseBookBlockBlockListener.getAreas().get(i3).getAllowedBlocks().size() == 0) {
                                player.sendMessage(ChatColor.GOLD + "All blocktypes are allowed in '" + areaName + "'");
                            } else {
                                int j = 0;
                                while (j < FalseBookBlockBlockListener.getAreas().get(i3).getAllowedBlocks().size()) {
                                    txt = String.valueOf(txt) + FalseBookBlockBlockListener.getAreas().get(i3).getAllowedBlocks().get(j).getTypeID() + ":" + FalseBookBlockBlockListener.getAreas().get(i3).getAllowedBlocks().get(j).getData();
                                    if (j < FalseBookBlockBlockListener.getAreas().get(i3).getAllowedBlocks().size() - 1) {
                                        txt = String.valueOf(txt) + ", ";
                                    }
                                    ++j;
                                }
                                player.sendMessage(ChatColor.GOLD + "Allowed blocktypes in '" + areaName + "':");
                                player.sendMessage(ChatColor.GRAY + txt);
                            }
                            f = true;
                        }
                        --i3;
                    }
                    if (!f) {
                        player.sendMessage(ChatColor.RED + "Area '" + areaName + "' not found!");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Wrong syntax! Use '/fareaListAllow <areaname>'");
                }
            } else if (commandLabel.equalsIgnoreCase("fareatoggle") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.blocks.area") && args.length >= 2) {
                boolean f;
                areaName = "";
                int i = 0;
                while (i < args.length - 1) {
                    if (i > 0) {
                        areaName = String.valueOf(areaName) + " ";
                    }
                    areaName = String.valueOf(areaName) + args[i];
                    ++i;
                }
                if (args[args.length - 1].equalsIgnoreCase("AutoSave")) {
                    f = false;
                    int i4 = FalseBookBlockBlockListener.getAreas().size() - 1;
                    while (i4 >= 0) {
                        if (FalseBookBlockBlockListener.getAreas().get(i4).getAreaName().equalsIgnoreCase(areaName)) {
                            FalseBookBlockBlockListener.getAreas().get(i4).setAutoSave(!FalseBookBlockBlockListener.getAreas().get(i4).isAutoSave());
                            this.saveAreas(areaName, true);
                            player.sendMessage(ChatColor.GREEN + "Changed Autosave from Area '" + areaName + "' to: " + FalseBookBlockBlockListener.getAreas().get(i4).isAutoSave());
                            f = true;
                        }
                        --i4;
                    }
                    if (!f) {
                        player.sendMessage(ChatColor.RED + "Area '" + areaName + "' not found!");
                    }
                } else if (args[args.length - 1].equalsIgnoreCase("protect")) {
                    f = false;
                    int i5 = FalseBookBlockBlockListener.getAreas().size() - 1;
                    while (i5 >= 0) {
                        if (FalseBookBlockBlockListener.getAreas().get(i5).getAreaName().equalsIgnoreCase(areaName)) {
                            FalseBookBlockBlockListener.getAreas().get(i5).setProtect(!FalseBookBlockBlockListener.getAreas().get(i5).isProtect());
                            this.saveAreas(areaName, true);
                            player.sendMessage(ChatColor.GREEN + "Changed Protection from Area '" + areaName + "' to: " + FalseBookBlockBlockListener.getAreas().get(i5).isProtect());
                            f = true;
                        }
                        --i5;
                    }
                    if (!f) {
                        player.sendMessage(ChatColor.RED + "Area '" + areaName + "' not found!");
                    }
                }
            }
        }
        return true;
    }

    private void listAreas(Player player) {
        String str = ChatColor.GOLD + "List of Areas: " + ChatColor.WHITE;
        int i = 0;
        while (i < FalseBookBlockBlockListener.getAreas().size() - 1) {
            str = String.valueOf(str) + FalseBookBlockBlockListener.getAreas().get(i).getAreaName() + ", ";
            ++i;
        }
        if (FalseBookBlockBlockListener.getAreas().size() > 0) {
            str = String.valueOf(str) + FalseBookBlockBlockListener.getAreas().get(FalseBookBlockBlockListener.getAreas().size() - 1).getAreaName();
        }
        player.sendMessage(str);
    }

    private void deleteArea(Player player, String name) {
        boolean f = false;
        int i = FalseBookBlockBlockListener.getAreas().size() - 1;
        while (i >= 0) {
            if (FalseBookBlockBlockListener.getAreas().get(i).getAreaName().equalsIgnoreCase(name)) {
                FalseBookBlockBlockListener.getAreas().remove(i);
                this.saveAreas(name, false);
                player.sendMessage(ChatColor.GREEN + "Area '" + name + "' deleted!");
                f = true;
            }
            --i;
        }
        if (!f) {
            player.sendMessage(ChatColor.RED + "Area '" + name + "' not found!");
        }
    }

    public void saveAreas(String FileName, boolean delete) {
        String areaPath = "plugins/FalseBook/areas/";
        File folder = new File(areaPath);
        folder.mkdirs();
        if (!delete) {
            File f = new File(String.valueOf(areaPath) + FileName + ".db");
            f.delete();
        } else {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(areaPath) + FileName + ".db")));
                int i = 0;
                for (Area area : FalseBookBlockBlockListener.getAreas()) {
                    if (!area.getAreaName().equals(FileName)) continue;
                    ++i;
                }
                out.writeObject(i);
                for (Area area : FalseBookBlockBlockListener.getAreas()) {
                    if (!area.getAreaName().equals(FileName)) continue;
                    out.writeObject(area);
                }
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean loadArea(File FileName) {
        String areaPath = "plugins/FalseBook/areas/";
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(areaPath) + FileName.getName())));
            int count = (Integer)in.readObject();
            int i = 0;
            while (i < count) {
                try {
                    Area newArea = (Area)in.readObject();
                    newArea.initArea();
                    FalseBookBlockBlockListener.getAreas().add(newArea);
                }
                catch (Exception e) {
                    FalseBookBlockCore.printInConsole("An error occured while loading an Area...");
                }
                ++i;
            }
            in.close();
            FalseBookBlockCore.printInConsole(String.valueOf(count) + " Areas loaded from " + FileName.getName() + ".");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            FalseBookBlockCore.printInConsole("Error while reading " + areaPath + FileName.getName());
            return false;
        }
    }

    public boolean loadAreas() {
        String areaPath = "plugins/FalseBook/areas";
        File f = new File(areaPath);
        f.mkdirs();
        if (f.listFiles() == null) {
            return true;
        }
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                this.loadArea(file);
            }
            ++n2;
        }
        return true;
    }

    public boolean importAreas(Player player) {
        return false;
    }

    public static int getMaxBridgeLength(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return 20;
        }
        return Settings.get(worldName).getMaxBridgeLength();
    }

    public static int getMaxBridgeSideWidth(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return 3;
        }
        return Settings.get(worldName).getMaxBridgeSideWidth();
    }

    public static int getMaxDoorSideWidth(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return 3;
        }
        return Settings.get(worldName).getMaxDoorSideWidth();
    }

    public static int getMaxGateWidth(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return 16;
        }
        return Settings.get(worldName).getMaxGateWidth();
    }

    public boolean isBridgeEnabled(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return true;
        }
        return Settings.get(worldName).isBridgeEnabled();
    }

    public boolean isDoorEnabled(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return true;
        }
        return Settings.get(worldName).isDoorEnabled();
    }

    public boolean isGateEnabled(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return true;
        }
        return Settings.get(worldName).isGateEnabled();
    }

    public static ArrayList<Integer> getAllowedGateBlocks(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return new ArrayList<Integer>();
        }
        return Settings.get(worldName).getAllowedGateBlocks();
    }

    public static ArrayList<Integer> getAllowedBridgeBlocks(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return new ArrayList<Integer>();
        }
        return Settings.get(worldName).getAllowedBridgeBlocks();
    }

    public static ArrayList<Integer> getAllowedDoorBlocks(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return new ArrayList<Integer>();
        }
        return Settings.get(worldName).getAllowedDoorBlocks();
    }

    public static FalseBookBlockBlockListener getBlockListener() {
        return blockListener;
    }

    public void loadVersion() {
        PluginDescriptionFile pdfFile = this.getDescription();
        pluginName = String.valueOf(pdfFile.getName()) + " v" + pdfFile.getVersion() + " by GeMo";
    }

    private boolean searchCore() {
        PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("FalseBookCore") != null) {
            if (pm.getPlugin("FalseBookCore").isEnabled()) {
                this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
                return true;
            }
            this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
            return true;
        }
        return false;
    }

    public void setCore(FalseBookCore core) {
        this.core = core;
    }

    public FalseBookCore getCore() {
        return this.core;
    }

    public static int getAreaSelectionTool(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return Material.WOOD_HOE.getId();
        }
        return Settings.get(worldName).getAreaSelectionTool();
    }

    public static boolean isCraftOnWorkbench(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return false;
        }
        return Settings.get(worldName).isCraftOnWorkbench();
    }

    public static float getAppleDropChance(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return 10.0f;
        }
        return Settings.get(worldName).getAppleDropChance();
    }

    public static boolean isReadBooks(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return true;
        }
        return Settings.get(worldName).isReadBooks();
    }

    public static boolean isLightswitchEnabled(String worldName) {
        if (!Settings.containsKey(worldName)) {
            return true;
        }
        return Settings.get(worldName).isLightswitchEnabled();
    }

    public static HashMap<String, BlockWorldSettings> getSettings() {
        return Settings;
    }

    public static void setSettings(HashMap<String, BlockWorldSettings> settings) {
        Settings = settings;
    }
}

