/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.detection;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.utils.FBBlockType;
import com.gemo.utils.SignUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1263
extends BaseIC {
    public MC1263(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "BLOCK SENSOR";
        this.MCName = "[MC1263]";
        this.MCGroup = "detection";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output: High if the block is present", "", "");
        this.chipState.setLines("Y offset, with 0 being the IC block. Leave blank to default to the block below.", "BlockID[:SubID]");
        this.ICDescription = "The MC1263 checks for the presence of a specified block relative to the block behind the IC sign whenever the input goes from low to high. By default it checks the block directly underneath but this can be changed.<br /><br />The <a href=\"MC0263.html\">MC0263</a> is the selftriggered version.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        Player player;
        block10: {
            if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
                MC1263.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
                return;
            }
            player = event.getPlayer();
            if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
                event.setLine(0, this.Name);
                event.setLine(1, this.MCName);
                if (event.getLine(2).length() < 1) {
                    event.setLine(2, "-1");
                }
                String yOffset = event.getLine(2);
                try {
                    if (yOffset.length() > 0) {
                        Integer.parseInt(yOffset);
                    }
                }
                catch (NumberFormatException e) {
                    MC1263.cancelCreation(event, "The third line must be a number or be blank.");
                    return;
                }
                String[] split = event.getLine(3).split(":");
                try {
                    if (!MC1263.isValidBlock(Integer.valueOf(split[0]))) {
                        MC1263.cancelCreation(event, "Block not found");
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    if (!MC1263.isValidBlock(MC1263.getItemIDFromName(event.getLine(3)))) {
                        MC1263.cancelCreation(event, "Block not found");
                        return;
                    }
                    break block10;
                }
            }
            MC1263.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1263.getBlockPositions(signBlock);
        if (MC1263.isPowered(positions.get(0))) {
            int offSet;
            int ItemID = -1;
            Byte ItemData = 0;
            Block block = null;
            ArrayList thisItems = SignUtils.parseItems((String)signBlock.getLine(3), (String)"-", (boolean)true);
            if (thisItems.size() != 1) {
                return;
            }
            ItemID = ((FBBlockType)thisItems.get(0)).getItemID();
            ItemData = ((FBBlockType)thisItems.get(0)).getItemData();
            int i = 0;
            while (i < thisItems.size()) {
                thisItems.set(i, null);
                ++i;
            }
            thisItems.clear();
            thisItems = null;
            try {
                offSet = Integer.valueOf(signBlock.getLine(2));
            }
            catch (Exception e) {
                offSet = -1;
            }
            block = MC1263.getICBlock(signBlock).getBlock().getRelative(0, offSet, 0);
            if (ItemID == -1) {
                return;
            }
            if (block.getTypeId() == ItemID && (block.getData() == ItemData.byteValue() || ItemData == -1)) {
                MC1263.switchLever(signBlock, true);
            } else {
                MC1263.switchLever(signBlock, false);
            }
            block = null;
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

