/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC0111
extends SelftriggeredBaseIC {
    String networkName = "";
    boolean oldStatus;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 3;
        this.Name = "RECEIVER";
        this.MCName = "[MC0111]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("Received data", "", "");
        this.chipState.setLines("networkname", "");
        this.ICDescription = "The MC0111 receives the state in a particular band or network.<br /><br />The corresponding transmitter is the MC1110.";
    }

    public MC0111(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0111(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.networkName = this.signBlock.getLine(2);
        this.oldStatus = BaseIC.isActivated(this.signBlock);
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC0111.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            event.setLine(3, "");
            if (event.getLine(2) == null) {
                MC0111.cancelCreation(event, "Please define a Networkname!");
                return;
            }
            if (event.getLine(2).length() < 1) {
                MC0111.cancelCreation(event, "Please define a Networkname!");
                return;
            }
        } else {
            MC0111.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        this.networkName = event.getLine(2);
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
    }

    public void setStatus(boolean newStatus) {
        if (newStatus != this.oldStatus) {
            this.oldStatus = newStatus;
            MC0111.switchLever(this.signBlock, newStatus);
        }
    }
}

