/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;

public class MC0260
extends SelftriggeredBaseIC {
    private boolean oldStatus;
    private Block myBlock = null;
    private boolean result;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 7;
        this.Name = "WATER SENSOR";
        this.MCName = "[MC0260]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("Output: High if water is present", "", "");
        this.chipState.setLines("Y offset, with 0 being the IC block. Leave blank to default to the block below. ", "");
        this.ICDescription = "The MC0260 checks for the presence of water relative to the block behind the IC sign. By default it checks the block directly underneath but this can be changed.";
    }

    public MC0260(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0260(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.oldStatus = MC0260.isActivated(this.signBlock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC0260.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC0260.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(3, "");
        if (event.getLine(2).length() < 1) {
            event.setLine(2, "-1");
        }
        String yOffset = event.getLine(2);
        try {
            if (yOffset.length() > 0) {
                Integer.parseInt(yOffset);
            }
        }
        catch (NumberFormatException e) {
            MC0260.cancelCreation(event, "The third line must be a number or be blank.");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            try {
                this.myBlock = MC0260.getICBlock(this.signBlock).getBlock().getRelative(0, Integer.valueOf(this.signBlock.getLine(2)).intValue(), 0);
            }
            catch (Exception e) {
                this.myBlock = null;
            }
            this.startUp = false;
        }
        if (this.myBlock == null) {
            return;
        }
        boolean bl = this.result = this.myBlock.getTypeId() == 8 || this.myBlock.getTypeId() == 9;
        if (this.result != this.oldStatus) {
            this.oldStatus = this.result;
            MC0260.switchLever(this.signBlock, this.result);
        }
    }
}

