/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;

public class MC0270
extends SelftriggeredBaseIC {
    private boolean oldStatus;
    private Block myBlock = null;
    private boolean result;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 11;
        this.Name = "POWER SENSOR";
        this.MCName = "[MC0270]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("Output: High if the block is powered", "", "");
        this.chipState.setLines("Y offset, with 0 being the IC block. Leave blank to default to the block below.", "");
        this.ICDescription = "The MC0270 checks for a powered block relative to the block behind the IC sign. By default it checks the block directly underneath but this can be changed.";
    }

    public MC0270(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0270(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.oldStatus = MC0270.isActivated(this.signBlock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC0270.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC0270.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(3, "");
        if (event.getLine(2).length() < 1) {
            event.setLine(2, "-1");
        }
        String yOffset = event.getLine(2);
        try {
            if (yOffset.length() > 0) {
                Integer.parseInt(yOffset);
            }
        }
        catch (NumberFormatException e) {
            MC0270.cancelCreation(event, "The third line must be a number or blank.");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            try {
                this.myBlock = MC0270.getICBlock(this.signBlock).getBlock().getRelative(0, Integer.valueOf(this.signBlock.getLine(2)).intValue(), 0);
            }
            catch (Exception e) {
                this.myBlock = null;
            }
            this.startUp = false;
        }
        if (this.myBlock == null) {
            return;
        }
        boolean bl = this.result = this.myBlock.isBlockPowered() || this.myBlock.isBlockIndirectlyPowered();
        if (this.result != this.oldStatus) {
            this.oldStatus = this.result;
            MC0270.switchLever(this.signBlock, this.result);
        }
    }
}

