/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;

public class MC0285
extends SelftriggeredBaseIC {
    private World myWorld;
    private int mode = -1;
    private boolean isRain = false;
    private boolean isThunder = false;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 17;
        this.Name = "SET WEATHER";
        this.MCName = "[MC0285]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("", "", "");
        this.chipState.setLines("SUN or RAIN or STORM", "");
        this.ICDescription = "The MC0285 sets the weather to the specified weather, whenever the weather changes.";
    }

    public MC0285(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0285(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        String line;
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC0285.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            event.setLine(3, "");
            line = event.getLine(2);
            if (!(line.equalsIgnoreCase("sun") || line.equalsIgnoreCase("rain") || line.equalsIgnoreCase("storm"))) {
                MC0285.cancelCreation(event, ChatColor.RED + "Line 3 must be sun, rain or storm");
                return;
            }
        } else {
            MC0285.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(2, line.toUpperCase());
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            this.myWorld = this.signBlock.getWorld();
            String line = this.signBlock.getLine(2);
            if (!(line.equalsIgnoreCase("sun") || line.equalsIgnoreCase("rain") || line.equalsIgnoreCase("storm"))) {
                this.mode = -1;
            } else if (line.equalsIgnoreCase("sun")) {
                this.mode = 0;
            } else if (line.equalsIgnoreCase("rain")) {
                this.mode = 1;
            } else if (line.equalsIgnoreCase("storm")) {
                this.mode = 2;
            }
        }
        if (this.myWorld == null) {
            return;
        }
        this.isRain = this.myWorld.hasStorm();
        this.isThunder = this.myWorld.isThundering();
        if (this.mode == 0) {
            if (this.isRain || this.isThunder) {
                this.signBlock.getWorld().setStorm(false);
                this.signBlock.getWorld().setThundering(false);
            }
        } else if (this.mode == 1) {
            if (!this.isRain || this.isThunder) {
                this.signBlock.getWorld().setStorm(true);
                this.signBlock.getWorld().setThundering(false);
            }
        } else if (!(this.mode != 2 || this.isRain && this.isThunder)) {
            this.signBlock.getWorld().setStorm(true);
            this.signBlock.getWorld().setThundering(true);
        }
    }
}

