/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1030
extends BaseIC {
    public MC1030(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "INPUT EQUALS";
        this.MCName = "[MC1030]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, false, "Input A", "Input B", "");
        this.chipState.setOutputs("Output: A == B", "Output: A high, B low", "Output: A low, B high");
        this.ICDescription = "The MC1030 outputs if Input A equals Input B. <br /><ul><li>Input A equals Input B: Output 1 goes high, Output 2 & Output 3 go low</li><li>Input A is High, Input B is low: Output 2 goes high, Output 1 & Output 3 go low</li><li>Input B is high, Input A is low: Output 3 goes high, Output 1 & Output 2 go low</li></ul>";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1030.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC1030.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1030.getBlockPositions(signBlock);
        boolean inputA = MC1030.isPowered(positions.get(0));
        boolean inputB = MC1030.isPowered(positions.get(1));
        if (inputA && inputB || !inputA && !inputB) {
            MC1030.switchLever(signBlock, true, 3);
            MC1030.switchLeverLeft(signBlock, false, 2);
            MC1030.switchLeverRight(signBlock, false, 2);
        } else if (inputA && !inputB) {
            MC1030.switchLever(signBlock, false, 3);
            MC1030.switchLeverLeft(signBlock, true, 2);
            MC1030.switchLeverRight(signBlock, false, 2);
        } else if (!inputA && inputB) {
            MC1030.switchLever(signBlock, false, 3);
            MC1030.switchLeverLeft(signBlock, false, 2);
            MC1030.switchLeverRight(signBlock, true, 2);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

