/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1050
extends BaseIC {
    public MC1050(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "SELECTOR";
        this.MCName = "[MC1050]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, true, "Input A", "Input B", "Input C");
        this.chipState.setOutputs("Output A - goes high if: A is high, B & C are low", "Output B - goes high if: B is high, A & C are low", "Output C - goes high if: C is high, A & B are low");
        this.ICDescription = "The MC1050 checks if only one of the three inputs is high. If more than one input is high, all three outputs are low.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1050.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC1050.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1050.getBlockPositions(signBlock);
        boolean inputA = MC1050.isPowered(positions.get(0));
        boolean inputB = MC1050.isPowered(positions.get(1));
        boolean inputC = MC1050.isPowered(positions.get(2));
        if (inputA && !inputB && !inputC) {
            MC1050.switchLever(signBlock, true, 3);
            MC1050.switchLeverLeft(signBlock, false, 2);
            MC1050.switchLeverRight(signBlock, false, 2);
        } else if (!inputA && inputB && !inputC) {
            MC1050.switchLever(signBlock, false, 3);
            MC1050.switchLeverLeft(signBlock, true, 2);
            MC1050.switchLeverRight(signBlock, false, 2);
        } else if (!inputA && !inputB && inputC) {
            MC1050.switchLever(signBlock, false, 3);
            MC1050.switchLeverLeft(signBlock, false, 2);
            MC1050.switchLeverRight(signBlock, true, 2);
        } else {
            MC1050.switchLever(signBlock, false, 3);
            MC1050.switchLeverLeft(signBlock, false, 2);
            MC1050.switchLeverRight(signBlock, false, 2);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

