/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICBlockListener;
import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC1110;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1111
extends BaseIC {
    public MC1111(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "RECEIVER";
        this.MCName = "[MC1111]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Received data", "", "");
        this.chipState.setLines("networkname", "");
        this.ICDescription = "The MC1111 receives the state in a particular band or network when the clock input goes from low to high.<br /><br />The corresponding transmitter is the MC1110.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1111.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            event.setLine(3, "");
            if (event.getLine(2) == null) {
                MC1111.cancelCreation(event, "Please define a Networkname!");
                return;
            }
            if (event.getLine(2).length() < 1) {
                MC1111.cancelCreation(event, "Please define a Networkname!");
                return;
            }
        } else {
            MC1111.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        String networkName;
        ArrayList<Location> positions = MC1111.getBlockPositions(signBlock);
        if (MC1111.isPowered(positions.get(0)) && (networkName = signBlock.getLine(2)).length() > 0) {
            boolean result = false;
            for (SelftriggeredBaseIC IC : FalseBookICBlockListener.getSensorList().values()) {
                if (!(IC instanceof MC1110) || !networkName.equalsIgnoreCase(((MC1110)IC).getNetworkName()) || !((MC1110)IC).getStatus()) continue;
                result = true;
                break;
            }
            MC1111.switchLever(signBlock, result);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

