/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC3036
extends BaseIC {
    public MC3036(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "D LEVL FLIPFLOP";
        this.MCName = "[MC3036]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, true, "Clock", "Data", "Reset");
        this.chipState.setOutputs("Output", "", "");
        this.ICDescription = "The MC3036 implements a flip flop that sets its output to the state of the D (\"data\") input whenever the clock input is high. If the D input changes state while the clock is low, the output will not change. Also, while the reset input is high the output state is forced to low.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC3036.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC3036.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC3036.getBlockPositions(signBlock);
        boolean inputD = MC3036.isPowered(positions.get(0));
        boolean inputC = MC3036.isPowered(positions.get(1));
        boolean inputR = MC3036.isPowered(positions.get(2));
        if (inputR) {
            MC3036.switchLever(signBlock, false);
        } else if (inputC) {
            MC3036.switchLever(signBlock, inputD);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

