/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC3040
extends BaseIC {
    public MC3040(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "MULTIPLEXER";
        this.MCName = "[MC3040]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, true, "Input A", "Input B", "Select");
        this.chipState.setOutputs("Output = A if C is high, B otherwise", "", "");
        this.ICDescription = "The MC3040 implements a multiplexer that sets its output to the state of either input A or B depending on the state of input C.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC3040.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC3040.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC3040.getBlockPositions(signBlock);
        boolean inputA = MC3040.isPowered(positions.get(0));
        boolean inputB = MC3040.isPowered(positions.get(1));
        boolean inputS = MC3040.isPowered(positions.get(2));
        if (inputS) {
            MC3040.switchLever(signBlock, inputA);
        } else {
            MC3040.switchLever(signBlock, inputB);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

