/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC4000
extends BaseIC {
    public MC4000(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "FULL ADDER";
        this.MCName = "[MC4000]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, true, "First bit to add", "Second bit to add", "Third bit to add (carry in)");
        this.chipState.setOutputs("Sum", "Carry out", "Carry out (always the same as Output2)");
        this.ICDescription = "The MC4000 implements a full adder. It adds the two input bits, adds the carry in (third bit), and returns the sum and the carry.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC4000.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC4000.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC4000.getBlockPositions(signBlock);
        boolean inputA = MC4000.isPowered(positions.get(0));
        boolean inputB = MC4000.isPowered(positions.get(1));
        boolean inputC = MC4000.isPowered(positions.get(2));
        boolean result = inputA ^ inputB ^ inputC;
        boolean carry = inputA & inputB | (inputA ^ inputB) & inputC;
        MC4000.switchLever(signBlock, result, 3);
        MC4000.switchLeverLeft(signBlock, carry, 2);
        MC4000.switchLeverRight(signBlock, carry, 2);
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

