/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC4010
extends BaseIC {
    public MC4010(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "HALF ADDER";
        this.MCName = "[MC4010]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(false, true, true, "Always ignored (front input)", "First bit to add", "Second bit to add");
        this.chipState.setOutputs("Sum", "Carry out", "Carry out (always the same as Output2)");
        this.ICDescription = "The MC4010 implements a half adder. It takes two one-bit inputs, adds them, and returns the sum and the carry.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC4010.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC4010.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC4010.getBlockPositions(signBlock);
        boolean inputB = MC4010.isPowered(positions.get(1));
        boolean inputC = MC4010.isPowered(positions.get(2));
        boolean result = inputB ^ inputC;
        boolean carry = inputB & inputC;
        MC4010.switchLever(signBlock, result, 3);
        MC4010.switchLeverLeft(signBlock, carry, 2);
        MC4010.switchLeverRight(signBlock, carry, 2);
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

