/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC4200
extends BaseIC {
    public MC4200(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "DISPATCHER";
        this.MCName = "[MC4200]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, true, "Input", "Clock A", "Clock B");
        this.chipState.setOutputs("(unused)", "Output A", "Output B");
        this.ICDescription = "The MC4200 implements a dispatcher that works similar to two MC3036 level-triggered D flip flops sharing the same input and having no reset input.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC4200.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC4200.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC4200.getBlockPositions(signBlock);
        boolean value = MC4200.isPowered(positions.get(0));
        boolean TargetB = MC4200.isPowered(positions.get(1));
        boolean TargetC = MC4200.isPowered(positions.get(2));
        if (TargetB) {
            MC4200.switchLeverLeft(signBlock, value, 2);
        }
        if (TargetC) {
            MC4200.switchLeverRight(signBlock, value, 2);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

