/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.utils.BlockUtils;
import com.gemo.utils.FBBlockType;
import com.gemo.utils.SignUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;

public class MC1201
extends BaseIC {
    public MC1201(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "DISPENSER";
        this.MCName = "[MC1201]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("ItemID[:SubID]", "Blank to drop one item or a number to drop more items (in a stack)");
        this.ICDescription = "The MC1201 spawns an item in the first free space above the block behind the IC sign when the input (the \"clock\") goes from low to high.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        Player player;
        block7: {
            if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
                MC1201.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
                return;
            }
            player = event.getPlayer();
            if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
                event.setLine(0, this.Name);
                event.setLine(1, this.MCName);
                if (event.getLine(2) == null) {
                    MC1201.cancelCreation(event, "Item not found");
                    return;
                }
                String[] split = event.getLine(2).split(":");
                try {
                    if (!BlockUtils.isValidItemID((int)Integer.valueOf(split[0]))) {
                        MC1201.cancelCreation(event, "Item not found");
                        return;
                    }
                    break block7;
                }
                catch (Exception e) {
                    if (BlockUtils.getItemIDFromName((String)event.getLine(2)) == 0) {
                        MC1201.cancelCreation(event, "Item not found");
                        return;
                    }
                    break block7;
                }
            }
            MC1201.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1201.getBlockPositions(signBlock);
        if (MC1201.isPowered(positions.get(0))) {
            ArrayList thisItems;
            World w = signBlock.getWorld();
            int ItemID = -1;
            int ItemCount = 1;
            byte ItemData = 0;
            if (signBlock.getLine(3).length() > 0) {
                try {
                    ItemCount = Integer.parseInt(signBlock.getLine(3));
                    if (ItemCount > 64) {
                        ItemCount = 64;
                    }
                    if (ItemCount < 1) {
                        ItemCount = 1;
                    }
                }
                catch (Exception e) {
                    ItemCount = 1;
                }
            }
            if ((thisItems = SignUtils.parseItems((String)signBlock.getLine(2), (String)"-", (boolean)true)).size() == 1) {
                ItemID = ((FBBlockType)thisItems.get(0)).getItemID();
                if (((FBBlockType)thisItems.get(0)).getItemData() != -1) {
                    ItemData = ((FBBlockType)thisItems.get(0)).getItemData();
                }
            }
            thisItems.clear();
            thisItems = null;
            if (ItemID < 1) {
                return;
            }
            ItemStack item = new ItemStack(ItemID, ItemCount, Short.valueOf("0").shortValue(), Byte.valueOf(ItemData));
            Location loc = MC1201.getICBlock(signBlock);
            int maxY = Math.min(128, loc.getBlockY() + 10);
            int y = loc.getBlockY() + 1;
            while (y <= maxY) {
                if (BlockUtils.canPassThrough((int)w.getBlockAt(loc.getBlockX(), y, loc.getBlockZ()).getTypeId())) {
                    Location sPos = loc;
                    sPos.setY((double)y);
                    w.dropItemNaturally(sPos, item);
                    MC1201.switchLever(signBlock, true);
                    return;
                }
                ++y;
            }
        } else {
            MC1201.switchLever(signBlock, false);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

