/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.utils.BlockUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1203
extends BaseIC {
    public MC1203(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "ZEUS BOLT";
        this.MCName = "[MC1203]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("", "");
        this.ICDescription = "The MC1203 generates a lighting bolt on the first free block above the block behind the IC sign when the input (the \"clock\") goes from low to high. ";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1203.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC1203.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1203.getBlockPositions(signBlock);
        if (MC1203.isPowered(positions.get(0))) {
            Location loc = MC1203.getICBlock(signBlock);
            int maxY = Math.min(128, loc.getBlockY() + 15);
            int y = 1;
            while (y <= maxY - loc.getBlockY()) {
                if (BlockUtils.canPassThrough((int)loc.getBlock().getRelative(0, y, 0).getTypeId())) {
                    signBlock.getWorld().strikeLightning(loc.getBlock().getRelative(0, y, 0).getLocation());
                    MC1203.switchLever(signBlock, true);
                    return;
                }
                ++y;
            }
        } else {
            MC1203.switchLever(signBlock, false);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

