/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.World;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.util.Vector;

public class MC1241
extends BaseIC {
    public MC1241(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "ARROW BARRAGE";
        this.MCName = "[MC1241]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("", "", "");
        this.chipState.setLines("Either speed or both speed and spread. Speed is a value between 0.2 and 2 and the default value is 0.6. Spread is a value between 0 and 50 and the default value is 12. Leave blank to use default. <br /><br />Speed[:Spread]", "Vertical velocity between -1 and 1, with 0 being the default. Leave blank to use default of 0.");
        this.ICDescription = "The MC1241 shoots five arrows when the input (the \"clock\") goes from low to high.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        Player player;
        block8: {
            if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
                MC1241.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
                return;
            }
            player = event.getPlayer();
            if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
                event.setLine(0, this.Name);
                event.setLine(1, this.MCName);
                String speedSpreadLine = event.getLine(2);
                String vertVelLine = event.getLine(3);
                try {
                    float speed;
                    if (speedSpreadLine.length() > 0) {
                        float spread;
                        String[] parts = speedSpreadLine.split(":");
                        float speed2 = Float.parseFloat(parts[0]);
                        if ((double)speed2 < 0.3 || speed2 > 2.0f) {
                            MC1241.cancelCreation(event, "Speed must be >= 0.3 and <= 2.");
                            return;
                        }
                        if (parts.length > 1 && ((spread = Float.parseFloat(parts[1])) < 0.0f || spread > 50.0f)) {
                            MC1241.cancelCreation(event, "Spread must be >= 0 and <= 50.");
                            return;
                        }
                    }
                    if (vertVelLine.length() > 0 && ((speed = Float.parseFloat(vertVelLine)) < -1.0f || speed > 1.0f)) {
                        MC1241.cancelCreation(event, "Vertical velocity must be between or equal to -1 and 1.");
                        return;
                    }
                    break block8;
                }
                catch (NumberFormatException e) {
                    MC1241.cancelCreation(event, "Speed is the third line and spread is the fourth line.");
                    return;
                }
            }
            MC1241.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1241.getBlockPositions(signBlock);
        if (MC1241.isPowered(positions.get(0))) {
            int dir = MC1241.getDirection(signBlock);
            float speed = 0.5f;
            float spread = 12.0f;
            float vertVel = 0.0f;
            Location location = MC1241.getLeverPos(signBlock).clone();
            location.setX(location.getX() + 0.5);
            location.setY(location.getY() + 0.5);
            location.setZ(location.getZ() + 0.5);
            String speedSpreadLine = signBlock.getLine(2);
            String vertVelLine = signBlock.getLine(3);
            try {
                if (speedSpreadLine.length() > 0) {
                    String[] parts = speedSpreadLine.split(":");
                    speed = Float.parseFloat(parts[0]);
                    if (parts.length > 1) {
                        spread = Float.parseFloat(parts[1]);
                    }
                }
                if (vertVelLine.length() > 0) {
                    vertVel = Float.parseFloat(vertVelLine);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            Vector velocity = new Vector(0.0f, 1.0f, 0.0f);
            if (dir == 1) {
                velocity = new Vector(0.0f, vertVel, -1.0f);
            } else if (dir == 2) {
                velocity = new Vector(-1.0f, vertVel, 0.0f);
            } else if (dir == 3) {
                velocity = new Vector(0.0f, vertVel, 1.0f);
            } else if (dir == 4) {
                velocity = new Vector(1.0f, vertVel, 0.0f);
            }
            CraftWorld w = (CraftWorld)signBlock.getWorld();
            int i = 0;
            while (i <= 4) {
                EntityArrow arrow = new EntityArrow((World)w.getHandle());
                arrow.setPositionRotation(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
                arrow.a(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
                w.getHandle().addEntity((Entity)arrow);
                ++i;
            }
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

