/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1511
extends BaseIC {
    public MC1511(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "COMMANDSENDER";
        this.MCName = "[MC1511]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("first part of the command", "second part of the command");
        this.ICDescription = "The MC1511 executes a configurable serverside command when the input (the \"clock\") goes from low to high.<br /><br />The command is always Line 3 + Line 4.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1511.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            String str = String.valueOf(event.getLine(2)) + event.getLine(3);
            if (str.length() < 1) {
                MC1511.cancelCreation(event, "Enter a command in line 3 AND/OR 4!");
                return;
            }
        } else {
            MC1511.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1511.getBlockPositions(signBlock);
        if (MC1511.isPowered(positions.get(0))) {
            String message = String.valueOf(signBlock.getLine(2)) + signBlock.getLine(3);
            if (message.length() < 1) {
                return;
            }
            FalseBookICCore.server.broadcastMessage(ChatColor.LIGHT_PURPLE + "[MC1511] Executing command: " + message);
            boolean res = FalseBookICCore.server.dispatchCommand((CommandSender)new ConsoleCommandSender(FalseBookICCore.server), message);
            if (res) {
                FalseBookICCore.server.broadcastMessage(ChatColor.LIGHT_PURPLE + "[MC1511] " + ChatColor.WHITE + "Command executed!");
            } else {
                FalseBookICCore.server.broadcastMessage(ChatColor.LIGHT_PURPLE + "[MC1511] " + ChatColor.RED + "Failed to execute command!");
            }
        }
        MC1511.switchLever(signBlock, MC1511.isPowered(positions.get(0)));
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

