/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome;

import me.taylorkelly.myhome.HomeList;
import me.taylorkelly.myhome.HomeSettings;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class MHPlayerListener
extends PlayerListener {
    private HomeList homeList;
    private Plugin plugin;

    public MHPlayerListener(HomeList homeList, Plugin plugin) {
        this.homeList = homeList;
        this.plugin = plugin;
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.homeList.homeExists(event.getPlayer().getName())) {
            this.homeList.orientPlayer(event.getPlayer());
        }
    }

    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        if (HomeSettings.bedsCanSethome != 0) {
            this.homeList.addHome(event.getPlayer(), this.plugin);
        }
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (HomeSettings.bedsDuringDay && event.getClickedBlock().getType() == Material.BED_BLOCK && HomeSettings.bedsCanSethome != 0) {
            this.homeList.addHome(event.getPlayer(), this.plugin);
        }
    }

    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (HomeSettings.loadChunks) {
            World world = event.getPlayer().getWorld();
            Chunk chunk = world.getChunkAt(event.getTo());
            int x = chunk.getX();
            int z = chunk.getZ();
            world.refreshChunk(x, z);
        }
    }

    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Location location;
        if (HomeSettings.respawnToHome && this.homeList.homeExists(event.getPlayer().getName()) && (location = this.homeList.getHomeFor(event.getPlayer()).getLocation(this.plugin.getServer())) != null) {
            event.setRespawnLocation(location);
            this.homeList.orientPlayer(event.getPlayer());
        }
    }
}

